
#ifndef _SETUP_H_
#define _SETUP_H_

#ifdef HAVE_KDELIBS3
#include <kdialogbase.h>
#else
#include "kdeui/kdialogbase.h"
#endif

// Includes panel fuentes:
#include <qvariant.h>
#include <qwidget.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QGroupBox;
class QLabel;
class QPushButton;
class KColorButton;

// Includes panel browser
class QCheckBox;
class QComboBox;

// Includes panel clipboard
class QSpinBox;


class Setup : public KDialogBase
{
    Q_OBJECT

public:
	Setup( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
	~Setup();

	void setMainFont(const QFont& font);
	void setOutputFont(const QFont& font);
	void setMiniwindowFont(const QFont& font);
	QFont getMainFont();
	QFont getOutputFont();
	QFont getMiniwindowFont();

	void setOutputColor( const QColor& color );
	void setMiniwindowColor( const QColor& color );
	QColor getOutputColor();
	QColor getMiniwindowColor();

	void setClipboardTime(int msec);
	int getClipboardTime();

	void setBrowser( const QString& nombre );
	QString getBrowser();

	void setInternalBrowser(bool b);
	bool getInternalBrowser();

	void setStyle( const QString& nombre );
	QString getStyle();

	void setEfecto( int tipo_efecto);
	int getEfecto();

	void setBigToolbar( bool big );
	bool getBigToolbar();

	void setMenubarVisible( bool b);
	bool isMenubarVisible();
	void setToolbarVisible( bool b);
	bool isToolbarVisible();
	void setStatusbarVisible( bool b);
	bool isStatusbarVisible();

	void setSavingCharset(const QString & charset);
	QString getSavingCharset();

	static Setup * dialog();

protected:
	QWidget* tab_fuentes;
	QWidget* tab_browser;
	QWidget* tab_clipboard;
	QWidget* tab_misc;
	QWidget* tab_charsets;

//Funciones
	void creaPanelFonts();
	void creaPanelBrowser();
	void creaPanelClipboard();
	void creaPanelMisc();
	void creaPanelCharsets();
	void setFuente( QLabel& label, const QFont & font );
	void cambiaFuente( QLabel& label );

	static Setup *static_dialog;

protected:
	// Widgets panel fuentes
    QGroupBox* groupFonts;
    QLabel* labelFontMain;
    QLabel* labelViewFontMain;
    QPushButton* cambiaFontMain;
    QGroupBox* groupOutput;
    QLabel* labelFontOutput;
    QPushButton* botonCambiaFontOutput;
    QLabel* labelColorOutput;
    QLabel* labelViewFontOutput;
    KColorButton* colorOutput;
    QGroupBox* groupMiniwindow;
    QLabel* labelFontMini;
    QPushButton* botonCambiaFontMini;
    QLabel* labelViewFontMini;
    QLabel* labelColorMini;
    KColorButton* colorMini;

protected:
    QVBoxLayout* FuentesLayout;
    QHBoxLayout* groupFontsLayout;
    QGridLayout* groupOutputLayout;
    QGridLayout* groupMiniwindowLayout;


	// Widgets panel browser
    QGroupBox* grupoBrowser;
    QLabel* labelBrowser;
    QComboBox* comboBrowser;
    QCheckBox* useBrowser;

protected:
    QVBoxLayout* BrowserLayout;
    QVBoxLayout* grupoBrowserLayout;


	// Widgets panel clipboard
    QLabel* labelClipboardText;
    QLabel* labelClipboard1;
    QSpinBox* inputClipboardTime;
    QLabel* labelClipboard2;

protected:
    QVBoxLayout* ClipboardLayout;
    QHBoxLayout* clipboardLayout1;


	// Widgets panel misc
    QGroupBox* grupoMisc;
    QCheckBox* showMenubar;
    QCheckBox* showToolbar;
    QCheckBox* showStatusbar;
    QComboBox* comboToolbar;
    QLabel* labelSize;
    QGroupBox* grupoEffects;
    QLabel* labelEffects;
    QLabel* labelStyle;
    QComboBox* comboStyle;
    QComboBox* comboEffects;

protected:
    QVBoxLayout* AppearanceLayout;
    QGridLayout* grupoMiscLayout;
    QGridLayout* grupoEffectsLayout;

	//Widgets panel charsets
    QLabel* labelCharsetExpl;
    QLabel* labelCharset;
    QComboBox* comboCharset;

protected:
    QVBoxLayout* CharsetsLayout;
    QHBoxLayout* charsetlayout1;


protected slots:
	void cambiarFuentePrincipal();
	void cambiarFuenteSalida();
	void cambiarFuenteMini();
};

#endif // _SETUP_H_

