/* dirfiltersettings.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DIRFILTERSETTINGS_HH
#define DIRFILTERSETTINGS_HH

#include "wdefines.h"
#include "nmfilter.hh"
#include <list>
#include <memory>
#include "stringmatcher.hh"

class DirFilterSettings
{
public:
    DirFilterSettings();
    ~DirFilterSettings();
    
    bool check( class FileEntry &e );

    int getSerialNr() const;

    void setShowHidden( bool nv );
    void setFilters( const std::list<NM_Filter> &filters );

    bool getShowHidden() const;
    std::list<NM_Filter> getFilters();

    bool filterActive() const;
    void unsetAllFilters();
    void setFilter( const char *filter, NM_Filter::check_t mode );
    
    void setStringFilter( std::auto_ptr<StringMatcher> filter );
private:
    void calcInAndOuts();

    int _serial_nr;
    bool _show_hidden;
    std::list<NM_Filter> _filters;
    int _ins, _outs;

    std::auto_ptr<StringMatcher> _string_filter;
};

#endif
