/* fileentry.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FILEENTRY_HH
#define FILEENTRY_HH

#include "wdefines.h"
#include "simplelist.hh"
#include <aguix/fieldlistview.h>
#include <aguix/fieldlistviewdnd.h>
#include "worker_types.h"
#include <list>

// how many characters are used for permission string
// NOT including the trailing null byte
#define WORKER_PERMCHARS 10

class WCFiletype;

class FileEntry
{
public:
  FileEntry();
  ~FileEntry();
  FileEntry( const FileEntry &other );
  FileEntry &operator=( const FileEntry &other );

  bool isDir() const;
  FileEntry *duplicate();
  int readInfos();
  int readInfos(bool);
  char *getDestination() const;
  int writeDestination2Buf(char*,int,bool);
  const char *getPermissionString();
  bool isExe( bool fastTest = false ) const;
  WCFiletype* checkFiletype( List *ftlist, bool skipcontent, class CondParser *condparser = NULL );
  bool match(char* pattern);
  bool checkAccess( int m );

  void setLVC( FieldListView *lv, int row, const std::vector<WorkerTypes::listcol_t> *dis );
  void setLVC_DND( FieldListViewDND *lv, int row, const std::vector<WorkerTypes::listcol_t> *dis );
  
  loff_t size() const;
  time_t lastaccess() const;
  time_t lastmod() const;
  time_t lastchange() const;
  mode_t mode() const;
  uid_t userid() const;
  gid_t groupid() const;
  ino_t inode() const;
  nlink_t nlink() const;
  loff_t blocks() const;
  loff_t dsize() const;
  time_t dlastaccess() const;
  time_t dlastmod() const;
  time_t dlastchange() const;
  mode_t dmode() const;
  uid_t duserid() const;
  gid_t dgroupid() const;
  ino_t dinode() const;
  nlink_t dnlink() const;
  loff_t dblocks() const;
  dev_t rdev() const;
  dev_t drdev() const;
  dev_t dev() const;
  dev_t ddev() const;
  
  char *getContentStr( int pos, int len = 1 );
  int getContentNum( int pos, int len = 1 );
  void freeContentBuf();

  struct FE_stat {
    loff_t size;
    time_t lastaccess;
    time_t lastmod;
    time_t lastchange;
    mode_t mode;
    uid_t userid;
    gid_t groupid;
    ino_t inode;
    nlink_t nlink;
    loff_t blocks;
    dev_t rdev;   // device type
    dev_t dev;    // device
  } statbuf, dstatbuf;

  char *fullname;
  char *name;
  loff_t dirsize;
  bool select;
  bool isLink;
  bool isCorrupt;
  
  WCFiletype *filetype;
  bool isHidden;
  bool use;
  
  bool reclistQueued;  // for filetype recognition in normalmode
  
  void freeOutputBuf();
  const char *findOutput( const char *tcommand );
  int findReturnvalue( const char *tcommand, int *return_value );
  int findOutputAndRV( const char *tcommand, const char **return_output, int *return_value );
  void addOutput( const char *tcommand, const char *toutput, int value = 0 );
  
  bool isReg() const;
  void setCustomColors( bool nv );
  bool getCustomColors() const;
  void setColor( int m, const int *v );
  void setColor( int m, int pos, int v );
  int getColor( int m, int pos ) const;
  const int *getColor( int m ) const;
  bool isSameFile( const char *othername, bool follow_symlinks ) const;
  bool equals( const FileEntry &fe ) const;
  bool equals( const FileEntry *fe ) const;

  int getID() const;
 protected:
  friend class Verzeichnis;
  void setID( int ID );
private:
  struct {
    char *content;
    int size;
  } contentBuf;
  void readContentBuf( int len = 64 );
  class StringBuf *outputBuf;

  typedef struct _typecandidate_t {
    _typecandidate_t()
    {
      prio = 0;
      tests_done = 0;
      type = NULL;
    }
    unsigned int prio;
    WCFiletype *type;
    int tests_done;
  } typecandidate_t;

  typecandidate_t runTests( WCFiletype *type,
			    bool skipcontent,
			    CondParser *condparser,
			    unsigned char fbuffer[64],
			    int reads );
  typecandidate_t checkFiletype( const std::list<WCFiletype*> *ftlist,
				 bool skipcontent,
				 CondParser *condparser,
				 unsigned char fbuffer[64],
				 int reads );

  bool customcolors;
  int fg[4], bg[4];

  int _ID;
};

#endif
