/* wconfig_layout.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "wconfig_layout.hh"
#include "wconfig.h"
#include "worker.h"
#include <aguix/acontainerbb.h>

static struct {
  WConfig::layoutID_t id;
  int descr;
} layoutDescr[] = { { WConfig::LO_STATEBAR, 556 },
                                 { WConfig::LO_CLOCKBAR, 557 },
                                 { WConfig::LO_BUTTONS, 558 },
                                 { WConfig::LO_LISTVIEWS, 559 },
                                 { WConfig::LO_BLL, 560 },
                                 { WConfig::LO_LBL, 561 },
                                 { WConfig::LO_LLB, 562 },
                                 { WConfig::LO_BL, 563 },
                                 { WConfig::LO_LB, 564 } };

static LayoutPanel::layoutIDGrp_t layouts[][5] = { { { WConfig::LO_STATEBAR, 0 },
                                                     { WConfig::LO_CLOCKBAR, 1 },
                                                     { WConfig::LO_BUTTONS, 2 },
                                                     { WConfig::LO_LISTVIEWS, 3 },
                                                     { WConfig::LO_DUMMY, -1 }
                                                   },
                                                   { { WConfig::LO_STATEBAR, 0 },
                                                     { WConfig::LO_CLOCKBAR, 1 },
                                                     { WConfig::LO_BUTTONS, 2 },
                                                     { WConfig::LO_LISTVIEWS, 3 },
                                                     { WConfig::LO_LISTVIEWS, 4 }
                                                   },
                                                   { { WConfig::LO_STATEBAR, 0 },
                                                     { WConfig::LO_CLOCKBAR, 1 },
                                                     { WConfig::LO_BLL, 2 },
                                                     { WConfig::LO_LBL, 2 },
                                                     { WConfig::LO_LLB, 2 }
                                                   },
                                                   { { WConfig::LO_STATEBAR, 0 },
                                                     { WConfig::LO_CLOCKBAR, 1 },
                                                     { WConfig::LO_BL, 2 },
                                                     { WConfig::LO_LB, 2 },
                                                     { WConfig::LO_DUMMY, -1 }
                                                   } };

int LayoutPanel::getNrOfLayoutModes()
{
  return sizeof( layouts ) / sizeof( layouts[0] );
}

int LayoutPanel::getNrOfLayoutElements()
{
  return sizeof( layouts[0] ) / sizeof( layouts[0][0] );
}

int LayoutPanel::getLayoutID(  bool buttonV, bool listviewV, int pos, layoutIDGrp_t &return_id )
{
  int mode, i;
  int modes, epmode;

  if ( ( buttonV == false ) && ( listviewV == false ) ) {
    mode = 0;
  } else if ( ( buttonV == false ) && ( listviewV == true ) ) {
    mode = 1;
  } else if ( ( buttonV == true ) && ( listviewV == false ) ) {
    mode = 2;
  } else {
    mode = 3;
  }

  modes = getNrOfLayoutModes();
  if ( ( mode >= 0 ) && ( mode < modes ) ) {
    if ( pos >= 0 ) {
      epmode = getNrOfLayoutElements();
      for ( i = 0; i < epmode; i++ ) {
        if ( layouts[mode][i].id == WConfig::LO_DUMMY ) break;
        if ( i == pos ) {
          return_id.id = layouts[mode][i].id;
          return_id.group = layouts[mode][i].group;
          return 0;
        }
      }
    }
  }
  return_id.id = WConfig::LO_DUMMY;
  return_id.group = -1;
  return 1;
}

int LayoutPanel::getNrOfUniques( bool bv, bool lvv )
{
  int modes, epmode, i;
  layoutIDGrp_t id;
  int u = -1;

  modes = getNrOfLayoutModes();
  epmode = getNrOfLayoutElements();
  
  for ( i = 0; i < epmode; i++ ) {
    if ( getLayoutID( bv, lvv, i, id ) == 0 ) {
      u = id.group;
    } else break;
  }
  return ( u + 1 );
}

int LayoutPanel::getSizeOfGroup( bool bv, bool lvv, int group )
{
  int elems = 0;
  int modes, epmode, i;
  layoutIDGrp_t id;

  modes = getNrOfLayoutModes();
  epmode = getNrOfLayoutElements();
  
  for ( i = 0; i < epmode; i++ ) {
    if ( getLayoutID( bv, lvv, i, id ) == 0 ) {
      if ( id.group == group ) elems++;
    } else break;
  }
  return elems;
}

std::string LayoutPanel::getDescrOfLayoutID( WConfig::layoutID_t id )
{
  int s, i;
  std::string s1;
  
  s = sizeof( layoutDescr ) / sizeof( layoutDescr[0] );
  s1 = "";
  for ( i = 0; i < s; i++ ) {
    if ( layoutDescr[i].id == id ) {
      s1 = catalog.getLocale( layoutDescr[i].descr );
      break;
    }
  }
  return s1;
}

int LayoutPanel::setupLayoutContainer()
{
  Button *b1;
  int uniques;
  int pos, i, s, ts;
  AContainer *tac;
  layoutIDGrp_t layoutid;
  std::list<confLayoutEntry_t>::iterator it1;
  confLayoutEntry_t entry;

  for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
    delete (*it1).button;
  }
  entries.clear();

  if ( aclayout != NULL ) delete aclayout;
  
  uniques = getNrOfUniques( bv, lvv );
  aclayout = ac1->add( new AContainer( this, 1, uniques ), 0, 4 );
  aclayout->setMaxSpace( 5 );
  aclayout->setBorderWidth( 5 );

  pos = 0;
  for ( i = 0; i < uniques; i++ ) {
    s = getSizeOfGroup( bv, lvv, i );
    tac = aclayout->add( new AContainer( this, 1, s ), 0, i );
    tac->setMaxSpace( 0 );
    tac->setMinSpace( 0 );
    tac->setBorderWidth( 0 );
    for ( ts = 0; ts < s; ts++ ) {
      if ( getLayoutID( bv, lvv, pos, layoutid ) == 0 ) {
        b1 = (Button*)tac->add( new Button( _aguix, 
                                            0,
                                            0,
                                            "",
                                            1,
                                            0,
                                            pos ), 0, ts, AContainer::CINCW );
        b1->connect( this );
        entry.button = b1;
        entry.pos = pos;
        entry.ind = -1;
        entries.push_back( entry );
      } else break;
      pos++;
    }
  }
  return 0;
}

int LayoutPanel::updateLayoutButtonText()
{
  std::list<confLayoutEntry_t>::iterator it1;
  layoutIDGrp_t layoutid;
  std::string s1, s2;
  int pos;
  char buf1[ A_BYTESFORNUMBER( int ) ];

  for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
    pos = (*it1).pos;
    if ( getLayoutID( bv, lvv, pos, layoutid ) == 0 ) {
      s1 = getDescrOfLayoutID( layoutid.id );
      if ( (*it1).ind >= 0 ) {
        s1 += ": ";
        sprintf( buf1, "%d", (*it1).ind );
        s1 += buf1;
      } else {
        s1 += "   ";
      }
      if ( pos == history ) {
        s2 = "--> ";
        s2 += s1;
        s2 += " <--";
        s1 = s2;
      }
      (*it1).button->setText( 0, s1.c_str() );
    }
  }
  return 0;
}

LayoutPanel::LayoutPanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
  aclayout = ac1 = NULL;
  history = -1;
  bv = lvv = false;
  cb1 = cb2 = NULL;
}

LayoutPanel::~LayoutPanel()
{
}

int LayoutPanel::create()
{
  int res;
  
  res = Panel::create();

  std::list<confLayoutEntry_t>::iterator it1, it2;
  layoutIDGrp_t layoutid;
  int grp;
  int n, i;
  Text **texts;
  std::list<WConfig::layoutID_t>::iterator it3;
  int ind;

  bv = _baseconfig.getLayoutButtonVert();
  lvv = _baseconfig.getLayoutListviewVert();

  // global container 1x3
  ac1 = setContainer( new AContainer( this, 1, 5 ), true );
  ac1->setMaxSpace( 5 );
  ac1->setBorderWidth( 5 );

  addMultiLineText( catalog.getLocale( 690 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );
  
  ac1->add( new Text( _aguix, 0, 0, catalog.getLocale( 565 ), 1 ), 0, 1, AContainer::CINCWNR );
  // sub container 2x2 for lister config
  AContainer *ac2 = ac1->add( new AContainer( this, 2, 1 ), 0, 2 );
  ac2->setMaxSpace( 5 );
  ac2->setBorderWidth( 0 );
  
  cb1 = (ChooseButton*)ac2->add( new ChooseButton( _aguix,
                                                   0,
                                                   0,
                                                   20,
                                                   20,
                                                   ( bv == true ) ? 1 : 0,
                                                   catalog.getLocale( 567 ),
                                                   LABEL_LEFT,
                                                   1,
                                                   0 ), 0, 0, AContainer::CINCWNR );
  cb1->connect( this );
  cb2 = (ChooseButton*)ac2->add( new ChooseButton( _aguix,
                                                   0,
                                                   0,
                                                   20,
                                                   20,
                                                   ( lvv == true ) ? 1 : 0,
                                                   catalog.getLocale( 568 ),
                                                   LABEL_LEFT,
                                                   1,
                                                   0 ), 1, 0, AContainer::CINCWNR );
  cb2->connect( this );
  
  addTextFromString( catalog.getLocale( 566 ), 0, 0, 0, &texts, &n, NULL );
  AContainer *actext = ac1->add( new AContainer( this, 1, n ), 0, 3 );
  actext->setMaxSpace( 5 );
  actext->setBorderWidth( 0 );
  for ( i = 0; i < n; i++ ) {
    actext->add( texts[i], 0, i, AContainer::CINCWNR );
  }
  _freesafe( texts );
  
  setupLayoutContainer();

  ind = 0;
  // for all elements
  for ( it3 = _baseconfig.getLayoutOrders().begin(); it3 != _baseconfig.getLayoutOrders().end(); it3++ ) {
    // search entry without position (some layouts can be used more than once)
    for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
      if ( getLayoutID( bv, lvv, (*it1).pos, layoutid ) == 0 ) {
        if ( ( layoutid.id == (*it3) ) && ( (*it1).ind < 0 ) ) break;
      }
    }
    if ( it1 != entries.end() ) {
      // found candidate
      // now check if there is no entry with a position in the same group
      if ( getLayoutID( bv, lvv, (*it1).pos, layoutid ) == 0 ) {
        grp = layoutid.group;
        for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
          if ( getLayoutID( bv, lvv, (*it2).pos, layoutid ) == 0 ) {
            if ( ( layoutid.group == grp ) && ( (*it2).ind >= 0 ) ) break;
          }
        }
        if ( it2 == entries.end() ) {
          // not found
          (*it1).ind = ind++;
        }
      }
    }
  }

  updateLayoutButtonText();
  
  contMaximize( true );
  return 0;
}

int LayoutPanel::saveValues()
{
  int i, pos;
  layoutIDGrp_t layoutid;
  std::list<confLayoutEntry_t>::iterator it1;

  // Werte bernehmen
  _baseconfig.clearLayoutOrders();
  for ( i = 0; i < getNrOfUniques( bv, lvv ); i++ ) {
    for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
      if ( (*it1).ind == i ) {
        pos = (*it1).pos;
        if ( getLayoutID( bv, lvv, pos, layoutid ) == 0 ) {
          _baseconfig.layoutAddEntry( layoutid.id );
        }
      }
    }
  }
  _baseconfig.setLayoutButtonVert( bv );
  _baseconfig.setLayoutListviewVert( lvv );
  return 0;
}

void LayoutPanel::run( Widget *elem, AGMessage &msg )
{
  std::list<confLayoutEntry_t>::iterator it1, it2;
  int temp, grp, newind;
  layoutIDGrp_t layoutid, templayoutid;

  if ( msg.type == AG_BUTTONCLICKED ) {
    for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
      if ( (*it1).button == msg.button.button ) {
        // found button
        
        if ( (*it1).ind >= 0 ) {
          // button has already an index
          // goes to history if there was no history
          // otherwise remove index when button was the history
          // and swap with history otherwise
          
          if ( history >= 0 ) {
            if ( history == (*it1).pos ) {
              // remove index
              for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                if ( (*it2).ind > (*it1).ind ) (*it2).ind--;
              }
              (*it1).ind = -1;
            } else {
              // search for other entry and swap index
              for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                if ( (*it2).pos == history ) {
                  temp = (*it2).ind;
                  (*it2).ind = (*it1).ind;
                  (*it1).ind = temp;
                  break;
                }
              }
            }
            history = -1;
          } else history = (*it1).pos;
        } else {
          // no index
          // find new value and remove index from other elements from the same
          // group
          if ( getLayoutID( bv, lvv, (*it1).pos, layoutid ) == 0 ) {
            grp = layoutid.group;
            for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
              if ( getLayoutID( bv, lvv, (*it2).pos, templayoutid ) == 0 ) {
                if ( ( templayoutid.group == grp ) &&
                     ( (*it2).ind >= 0 ) ) {
                  break;
                }
              }
            }
            if ( it2 != entries.end() ) {
              // found other group member
              (*it1).ind = (*it2).ind;
              (*it2).ind = -1;
            } else {
              // choose next free index
              newind = 0;
              for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                if ( (*it2).ind >= newind ) newind = (*it2).ind + 1;
              }
              (*it1).ind = newind;
            }
          }
          history = -1;
        }
        updateLayoutButtonText();
        break;
      }
    }
  } else if ( msg.type == AG_CHOOSECLICKED ) {
    history = -1;
    bv = cb1->getState();
    lvv = cb2->getState();
    setupLayoutContainer();
    updateLayoutButtonText();
    contMaximize( true );
  }
}
