/////////////////////////////////////////////////////////////////////////////
// Name:        common/clipcmn.cpp
// Purpose:     common (to all ports) wxClipboard functions
// Author:      Robert Roebling
// Modified by:
// Created:     28.06.99
// RCS-ID:      $Id: clipcmn.cpp,v 1.6.6.1 2005/06/20 17:40:37 MR Exp $
// Copyright:   (c) Robert Roebling
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// ============================================================================
// declarations
// ============================================================================

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "wx/clipbrd.h"
#include "wx/module.h"

#if wxUSE_CLIPBOARD

// ----------------------------------------------------------------------------
// wxClipboardModule: module responsible for initializing the global clipboard
// object
// ----------------------------------------------------------------------------

class wxClipboardModule : public wxModule
{
public:
    bool OnInit();
    void OnExit();

private:
    DECLARE_DYNAMIC_CLASS(wxClipboardModule)
};

// ----------------------------------------------------------------------------
// global data defined here
// ----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxClipboardModule, wxModule)

wxClipboard* wxTheClipboard = (wxClipboard *)NULL;

// ----------------------------------------------------------------------------
// implementation
// ----------------------------------------------------------------------------

wxClipboardBase::wxClipboardBase()
{
}

bool wxClipboardModule::OnInit()
{
    wxTheClipboard = new wxClipboard;

    return TRUE;
}

void wxClipboardModule::OnExit()
{
    delete wxTheClipboard;

    wxTheClipboard = (wxClipboard *)NULL;
}

#endif // wxUSE_CLIPBOARD
