/* $Id: addrbook_util.h,v 1.2 2002/11/14 22:33:51 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/

#ifndef __ADDR_BOOK_UTIL_H__
#define __ADDR_BOOK_UTIL_H__

/* Address book utility helper functions. */

void add_each_addr(struct _mail_addr *addr, string bookname);
void add_msg_addr(struct _mail_msg *msg, string bookname);
struct _mail_addr *find_addr(struct _mail_addr *addr);
struct _mail_addr *expand_addr_list(struct _mail_msg *msg,
	struct _mail_addr *addr);

/* Conversion functions */

bool convert_addrbook_mailrc(FILE *in, FILE *out);
bool convert_addrbook_pine(FILE *in, FILE *out);
bool convert_addrbook_text(FILE *in, FILE *out);

/* Load/Save */

bool save_addressbook(string bookname);
bool load_addressbook(string bookname);

bool load_addressbooks();
bool save_addressbooks();

#endif /* __ADDR_BOOK_UTIL_H__ */
