#include <stdlib.h>
#define _GNU_SOURCE
#include <getopt.h>
#include <string.h>

#include "args.h"
#include "cfg.h"

char ** args_arguments;
int args_number = 0;

void args_set_data(int num, char ** args)
{
	if ( !num )
		return;
	args_arguments = args;
	args_number = num;
}

char args_hasopt(const char * arg)
{ // 1 if arg was found, 0 else
	int i;
	char * cptr;
	if ( !args_number ) return 0;
	for(i=1; i<args_number; i++)
	{
		cptr = args_arguments[i];
		while ( *cptr == '-' ) cptr++;
		if ( !strcmp(arg, cptr) ) return 1;
	}
	return 0;
}

void args_parse()
{
	int c, optidx;
	struct option opts[] = {
		{"line", 1, NULL, 'l'},
		{"detach", 0, NULL, 'd'},
		{"config", 1, NULL, 'c'},
//		{, , , },
		{NULL, 0, NULL, 0}
	};

	if ( !args_number )
		return;
	if ( !config )
		return;
	
	for (;;)
	{
		c = getopt_long(args_number, args_arguments,
				"l:dc:", opts, &optidx);
		
		if ( c==-1 ) break;
		
		switch ( c )
		{
			case 0:
				// printf("option %s recognized but not handled.\n", opts[optidx]);
				break;
			case 'l':
				if ( sscanf(optarg, "%u", &optidx) )
					config->default_line = optidx;
				break;
			case 'd':
				config->detach = TRUE;
				break;
			case 'c':
				if ( !cfgfile ) cfgfile = strdup(optarg);
				break;
		}
	}
}
