#!/bin/sh
#
# @(#)genidx.sh	6.16 00/01/12
#
# Generate xmcd Local Discography per-category index files
# Can be run periodically by cron(1M).
#
#    xmcd  - Motif(tm) CD Audio Player
#    cda   - Command-line CD Audio Player
#    libdi - CD Audio Player Device Interface Library
#
#    Copyright (C) 1993-2000  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
PATH=/bin:/usr/bin:/usr/local/bin; export PATH

# Modify these to suit your local configuration
XMCDLIB=/usr/lib/X11/xmcd
DISCOGDIR=$XMCDLIB/discog
FILE_MODE=666

CATEGORIES="rock jazz blues folk reggae newage classical country soundtrack misc data"
XMCD_EMAIL=xmcd@amb.org
XMCD_URL=http://metalab.unc.edu/tkan/xmcd/
CDDB_URL=http://www/cddb.com/
REVIEWS_URL=http://www.yahoo.com/Entertainment/Music/Reviews/
TMPFILE=/tmp/_gilist.$$

echo ""
echo "Generating xmcd Local Discography category index..."
echo ""

if [ ! -d $DISCOGDIR ]
then
	echo "  Error: cannot process $DISCOGDIR" >&2
	exit 1
fi

cd $DISCOGDIR
for i in $CATEGORIES
do
	if [ ! -d "$i" ]
	then
		echo "  $DISCOGDIR/$i does not exist: skipping." >&2
		continue
	fi

	echo "  Scanning $i"
	rm -f $i/index.html
	(
		cd $i
		echo "<!-- xmcd Local Discography index"
		echo "     DO NOT EDIT: Generated by @(#)genidx.sh	6.16 00/01/12"
		echo "     Copyright (C) 1993-2000 Ti Kan"
		echo "     E-mail: $XMCD_EMAIL URL: $XMCD_URL -->"
		echo "<HTML>"
		echo "<HEAD>"
		echo "<TITLE>xmcd: Local Discographies index for &quot;${i}&quot;</TITLE>"
		echo "</HEAD>"
		echo "<BODY BGCOLOR=\"$FFFFFF\" BACKGROUND=\"../bkgnd.gif\">"
		echo "<DIV ALIGN=\"center\">"

		echo "<A HREF=\"$XMCD_URL\">"
		echo "<IMG SRC=\"../xmcdlogo.gif\" ALT=\"xmcd\" BORDER=\"0\"></A>"
		echo "<H3>Local Discography: Index for &quot;${i}&quot;</H3>"
		echo "<P>"

		for j in *
		do
			if [ $j = index.html -o ! -r $j/index.html ]
			then
				continue
			fi
			dtitle=`grep "^<!-- tItLe:" $j/index.html | \
			sed -e 's/<!-- tItLe: //' -e 's/ -->//'`
			echo "$j $dtitle"
		done | sort -f +1 | awk '{ print $1 }' >$TMPFILE 2>&1

		first=1
		for j in `cat $TMPFILE`
		do
			if [ ! -r $j/index.html ]
			then
				continue
			fi
			if [ $first = 1 ]
			then
				first=0
				echo "<TABLE CELLSPACING=\"0\" CELLPADDING=\"2\" BORDER=\"1\""
				echo "<TR>"
				echo "<TD ALIGN=\"center\">Disc ID</TD>"
				echo "<TD ALIGN=\"center\">Description<BR></TD>"
				echo "</TR>"
			fi

			echo "<TR>"
			echo "<TD ALIGN=\"left\">"
			echo "<A HREF=\"$j/index.html\">$j</A>"
			echo "</TD>"
			echo "<TD ALIGN=\"left\">"

			grep "^<!-- tItLe:" $j/index.html | \
			sed -e 's/<!-- tItLe: //' -e 's/ -->//'

			echo "<BR></TD>"
			echo "</TR>"
		done
		rm -f $TMPFILE

		if [ $first = 1 ]
		then
			echo "<B>No entries found in this category</B>"
		else
			echo "</TABLE>"
		fi
		echo "<P>"
		echo "To re-generate this page, please run $XMCDLIB/scripts/genidx"
		echo "<P>"
		echo "</DIV>"

		echo "<H4>Local Discography</H4>"
		echo "<P>"
		echo "<UL>"
		echo "<LI>Browse category:"
		echo "<UL>"
		for k in $CATEGORIES
		do
			echo "<LI><A HREF=\"../$k/index.html\">$k</A>"
		done
		echo "</UL>"
		echo "</LI>"
		echo "<LI><A HREF=\"../discog.html\">How to set up Local Discography</A></LI>"
		echo "</UL>"

		echo "<H4>Links</H4>"
		echo "<P>"
		echo "<UL>"
		echo "<LI><A HREF=\"$XMCD_URL\">Browse the official Xmcd web site</A></LI>"
		echo "<LI><A HREF=\"$CDDB_URL\">Browse the official CDDB web site</A></LI>"
		echo "<LI><A HREF=\"$REVIEWS_URL\">Browse music reviews</A></LI>"
		echo "</UL>"

		echo "<HR>"
		echo "<FONT SIZE=\"-1\">Generated on `date` by @(#)genidx.sh	6.16 00/01/12</FONT>"
		echo "</BODY>"
		echo "</HTML>"

	) >$i/index.html

	chmod $FILE_MODE $i/index.html
done
exit 0


