/* winutils.h - xpm2wico - .xpm to Windows .ico format converter
 *
 * Copyright (C) 2002 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef WINUTILS_H
#define WINUTILS_H

typedef unsigned char Byte;
typedef unsigned short Word;

#if defined(__alpha) || (defined(_MIPS_SZLONG) && _MIPS_SZLONG == 64)
typedef unsigned int DWord;
typedef int Long;
#else
typedef unsigned long DWord;
typedef long Long;
#endif

/* Those functions read byte,word,dword,long in little-endian mode */
Byte read_byte (FILE *file);
Word read_word (FILE *file);
DWord read_dword (FILE *file);
#define read_long(f) (Long) read_dword(f)

void write_byte (FILE *file, Byte byte);
void write_word (FILE *file, Word word);
void write_dword (FILE *file, DWord dword);
void write_long (FILE *file, Long long_val);

#endif /* WINUTILS_H */
