#ifndef _pmu_h
#define _pmu_h

/*
 *  /proc/pmu parsing for xpmumon.
 *
 *  Copyright (c) 2002  Brendan O'Dea <bod@debian.org>
 *
 *  This is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

/* from linux/pmu.h */
#define PMU_BATT_PRESENT	0x00000001
#define PMU_BATT_CHARGING	0x00000002

/* these fields are set directly from /proc/pmu/battery_N */
struct batt_info {
    int flags;
    int charge;
    int max_charge;
    int current;
    int voltage;
    int time_rem;
};

int read_info(char const *key);
struct batt_info *read_battery(int bat);

#endif /* _pmu_h */
