/*-
# X-BASED MASTERBALL(tm)
#
#  MballP.h
#
###
#
#  Copyright (c) 1994 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Mball */

#ifndef _MballP_h
#define _MballP_h

#include "xwin.h"
#include "timer.h"
#include "Mball.h"

#ifdef WINVER
extern void DestroyPuzzle(HBRUSH brush);
extern void ResizePuzzle(MballWidget w);
extern void SizePuzzle(MballWidget w);
extern void InitializePuzzle(MballWidget w, HBRUSH brush);
extern void ExposePuzzle(MballWidget w);
extern void HidePuzzle(MballWidget w);
extern void SelectPuzzle(MballWidget w,
	const int x, const int y, const int shift);
extern void ReleasePuzzle(MballWidget w,
	const int x, const int y, const int shift);
extern void PracticePuzzle(MballWidget w);
extern void RandomizePuzzle(MballWidget w);
extern void GetPuzzle(MballWidget w);
extern void WritePuzzle(MballWidget w);
extern void UndoPuzzle(MballWidget w);
extern void RedoPuzzle(MballWidget w);
extern void ClearPuzzle(MballWidget w);
extern void SolvePuzzle(MballWidget w);
extern void IncrementPuzzle(MballWidget w);
extern Boolean DecrementPuzzle(MballWidget w);
extern void WedgePuzzle(MballWidget w, const int mode);
extern void Wedge2ModePuzzle(MballWidget w);
extern void Wedge4ModePuzzle(MballWidget w);
extern void Wedge6ModePuzzle(MballWidget w);
extern void Wedge8ModePuzzle(MballWidget w);
extern void Wedge10ModePuzzle(MballWidget w);
extern void Wedge12ModePuzzle(MballWidget w);
extern void OrientizePuzzle(MballWidget w);
extern void MiddlePuzzle(MballWidget w);
extern void SpeedPuzzle(MballWidget w);
extern void SlowPuzzle(MballWidget w);
extern void SoundPuzzle(MballWidget w);
extern void EnterPuzzle(MballWidget w);
extern void LeavePuzzle(MballWidget w);
extern void MovePuzzleInput(MballWidget w,
	int x, int direction, int shift, int control);
extern int  MoveMballDir(MballWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _MballClassPart {
	int         ignore;
} MballClassPart;

typedef struct _MballClassRec {
	CoreClassPart coreClass;
	MballClassPart mballClass;
} MballClassRec;

extern MballClassRec mballClassRec;
#endif

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TTR 1
#define TR 2
#define RIGHT 3
#define BR 4
#define BBR 5
#define BOTTOM 6
#define BBL 7
#define BL 8
#define LEFT 9
#define TL 10
#define TTL 11
#define COORD 12
#define CW 13
#define CCW 23
#define CUTS (COORD / 2)
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define MAXVIEWS 2

#define ST_ANG  (NUM_DEGREES/2)
#define RT_ANG  (NUM_DEGREES/4)
#define DEGREES(x) ((x)/M_PI*ST_ANG)
#define RADIANS(x) (M_PI*(x)/ST_ANG)
#define CIRCLE_2  (FULLCIRCLE/2)
#define CIRCLE_4  (FULLCIRCLE/4)

typedef struct _MoveRecord {
#if 0
	int wedge, direction, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
	int ring;                   /* Do not make assumptions on this one. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _MballStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} MballStack;

typedef struct _MballLoc {
	int wedge, direction;
} MballLoc;

typedef struct _MballPart {
	MballLoc   *mballLoc[MAXWEDGES];
	int         currentWedge, currentRing;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         base;
	int         wedges, rings;
	int         delay;
	Position    delta, dr;
	Position    mballLength;
	Position    wedgeLength;
	Position    viewLength, viewMiddle;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          wedgeGC[MAXWEDGES];
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        wedgeChar[MAXWEDGES];
#else
	int         menu, pixmapSize;
	char       *userName, *scoreFile, *moveSound, *font;
	XFontStruct *fontInfo;
	char       *wedgeName[MAXWEDGES];
	Pixel       foreground, background;
        Pixel       frameColor, borderColor;
	Pixel       wedgeColor[MAXWEDGES];
	XtCallbackList select;
#endif
} MballPart;

typedef struct _MballRec {
	CorePart    core;
	MballPart   mball;
} MballRec;

extern MballLoc *startLoc[MAXWEDGES];
extern void setPuzzle(MballWidget w, int reason);
extern void MovePuzzle(MballWidget w, const int wedge, const int ring,
	const int direction, const int control);

#if 0
/* For future auto-solver */
extern void SolveWedges(MballWidget w);

#endif
extern void DrawAllWedges(MballWidget w);
extern Boolean CheckSolved(MballWidget w);
extern void newMoves(MballStack *s);
extern void deleteMoves(MballStack *s);
extern void setMove(MballStack *s,
	int wedge, int ring, int direction, int control);
extern void getMove(MballStack *s,
	int *wedge, int *ring, int *direction, int *control);
extern int madeMoves(MballStack *s);
extern void flushMoves(MballWidget w, MballStack *s, Boolean undo);
extern int numMoves(MballStack *s);
extern void scanMoves(FILE *fp, MballWidget w, int moves);
extern void printMoves(FILE *fp, MballStack *s);
extern void scanStartPosition(FILE *fp, MballWidget w);
extern void printStartPosition(FILE *fp, MballWidget w);
extern void setStartPosition(MballWidget w);

#endif /* _MballP_h */
