/*******************************************************************
 * The core linux event loop.
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: linux_core.c
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: linux_core.c,v 1.24 2005/10/17 03:56:54 chessing Exp $
 * $Date: 2005/10/17 03:56:54 $
 * $Log: linux_core.c,v $
 * Revision 1.24  2005/10/17 03:56:54  chessing
 * Updates to the libxsupconfig library.  It no longer relies on other source from the main tree, so it can be used safely in other code with problems.
 *
 * Revision 1.23  2005/09/14 02:50:44  chessing
 * Major updates.  Auto association now works.  Started to rewrite the rtnetlink pieces using iwlib from the wireless tools to avoid compatibility issues.  As a result, getting the WPA and RSN IEs via the IWEVGENIE event no longer works for some reason, but the old style using IWEVCUSTOM events should still work like a champ.
 *
 * Revision 1.22  2005/09/05 01:00:37  chessing
 * Major overhaul to most of the state machines in Xsupplicant.  Also added additional error messages to the TLS functions to try to debug the one of the problems reported on the list.  Basic testing shows this new code to be more stable than previous code, but it needs more testing.
 *
 * Revision 1.21  2005/08/20 19:06:54  chessing
 * Patch from Carsten Grohmann to fix a few things in xsup_get_state.c.  Also added the ability to define an empty network clause, that will set the card in to encryption disabled mode.  From there, anything short of changing the SSID will be ignored by Xsupplicant.
 *
 * Revision 1.20  2005/08/18 03:19:04  chessing
 * Added the ability to define an SSID with static WEP keys.  When we switch to a network that has this type of configuration we will set the keys, and stop the various association timers.
 *
 * Revision 1.19  2005/08/09 01:39:15  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/

#ifdef LINUX_FRAMER

#include <sys/select.h>
#include <sys/socket.h>
#include <asm/types.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include <unistd.h>
#include <string.h>

#include "profile.h"
#include "xsupconfig.h"
#include "xsup_debug.h"
#include "xsup_err.h"
#include "wireless_sm.h"
#include "cardif/core.h"
#include "cardif/linux/cardif_linux_rtnetlink.h"

/*****************************************************************
 *
 * Do any setup that is needed for our event loop.
 *
 *****************************************************************/
void ext_event_init()
{
  cardif_linux_rtnetlink_init();
}

/*****************************************************************
 *
 * Process external events.  It is possible that the variable ws will be NULL!
 * Any functions that are called from here *MUST* take this in to account!
 *
 *****************************************************************/
void ext_event_core(struct interface_data *ctx, struct wireless_state *ws)
{
  if (TEST_FLAG(ctx->flags, IS_WIRELESS))
    {
      if (TEST_FLAG(ctx->flags, SCANNING))
	{
	  if (cardif_linux_rtnetlink_check_event(ctx, ws) != XDATA)
	    {
	      debug_printf(DEBUG_INT, "Waiting for SSID information...\n");
	      usleep(250000);
	    } 
	} else {
	  cardif_linux_rtnetlink_check_event(ctx, ws);
	}
    }
}

/******************************************************************
 *
 * Clean up anything that we initialized in ext_event_init().
 *
 ******************************************************************/
void ext_event_deinit()
{
  debug_printf(DEBUG_INT, "Called event_core_cleanup()!\n");
  cardif_linux_rtnetlink_cleanup();
}

#endif
