;*****************************************************
;
;	Video Technology library for small C compiler
;
;		Juergen Buchmueller
;
;*****************************************************

; ----- void vz_shape(int x, int y, int w, int h, int c, char *data)

XLIB vz_shape
XDEF char_shape
XREF scrbase

; This one is difficult to ween off the stack so left
; as is for another enterprising person to improve

.vz_shape

	ld	ix, -2          ; old compiler had an extra word on stack
	add	ix, sp
	ld	e, (ix+4)	; get *data
	ld	d, (ix+5)
	ld	iy, 0
	add	iy, de		; to IY

	ld	h,(ix+12)	; y coordinate
	ld	l,(ix+14)	; x coordinate

; convert HL to screen offset
	sla	l
	sra	h
	rr	l
	sra	h
        rr      l
	sra	h
        rr      l
	ld	de, (scrbase)
	add	hl, de

	ld	a, (ix+6)	; color
	and	3		; only 0..3 allowed
	ld	c, a
	ld	b, $fc		; pixel mask
        ld      a,(ix+14)        ; x offset
	and	3		; mask lower two bits of x
	xor	3		; flip 3->0, 2->1, 1->2, 0->3
	jr	z, shape1	; offset was 3, done
shape0:
	rlc	c		; shift color left
	rlc	c
	rlc	b		; shift mask left
        rlc     b
	dec	a		; more shifts?
	jr	nz, shape0
shape1:
        ld      a,(ix+12)        ; get y
	or	a		; negative ?
	jp	m, shape8	; next row
	cp	64		; above 64 ?
	jp	nc, shapex	; leave function
	ld	e,(ix+10)	; get width
shape2:
	push	bc		; save mask/color
	push	hl		; save screen offset
shape3:
	ld	d, (iy+0) 	; get data byte
	inc	iy		; increment data pointer
	ld	a, (hl) 	; get screen contents
shape4:
        rlc     d               ; next bit set?
	jr	nc, shape5	; no, skip
        and     b               ; remove old pixel
	or	c		; set new pixel
shape5:
	rrc	c		; rotate color
        rrc     c
	rrc	b		; rotate mask
	rrc	b
	jr	c, shape6	; mask not yet through? skip
	ld	(hl), a 	; store screen contents
        inc     hl              ; increment screen address
	ld	a, (hl) 	; get screen contents
shape6:
	dec	e		; decrement width
	jr	z, shape7	; zero: row done
	bit	0, e
	jr	nz, shape4	; odd count
	bit	1, e
        jr      nz, shape4      ; odd count
	bit	2, e
        jr      nz, shape4      ; odd count
	ld	(hl), a 	; store screen contents
        jr      shape3          ; fetch next datum
shape7:
	ld	(hl), a 	; store screen contents
        pop     hl              ; get back screen offset
        pop     bc              ; get back mask/color
	jr	shape9
shape8:
        ld      e,(ix+10)        ; get width
	ld	d,0
	ld	a,7		; + 7
	add	a,e
	ld	e,a
	ld	a,d
	adc	a,0
	ld	d,a
	sra	d		; / 8
	rr	e
	sra	d
        rr      e
	sra	d
        rr      e
	add	iy,de		; skip data bytes
shape9:
	ld	de, 32	 	; one row down
	add	hl, de
	inc	(ix+12)		; increment y
	dec	(ix+8)		; decrement h
	jp	nz, shape1	; more rows?
shapex:
	ret

char_shape:
	defb 0x00,0x00,0x00,0x00,0x00	; space
	defb 0x20,0x20,0x20,0x00,0x20	; !
	defb 0x50,0x50,0x00,0x00,0x00	; "
	defb 0x50,0xf8,0x50,0xf8,0x50	; #
	defb 0x78,0xa0,0x70,0x28,0xf0	; $
	defb 0xc8,0xd0,0x20,0x58,0x98	; %
	defb 0x40,0xa0,0x68,0x90,0x68	; &
	defb 0x20,0x20,0x40,0x00,0x00	; '
	defb 0x30,0x40,0x40,0x40,0x30	; (
	defb 0x60,0x10,0x10,0x10,0x60	; )
	defb 0xa8,0x70,0xf8,0x70,0xa8	; *
	defb 0x20,0x20,0xf8,0x20,0x20	; +
	defb 0x00,0x00,0x20,0x20,0x40	; ,
	defb 0x00,0x00,0xf8,0x00,0x00	; -
	defb 0x00,0x00,0x00,0x60,0x60	; .
	defb 0x08,0x10,0x20,0x40,0x80	; /
	defb 0x70,0x88,0xa8,0x88,0x70	; 0
	defb 0x20,0x60,0x20,0x20,0x70	; 1
	defb 0xf0,0x08,0x70,0x80,0xf8	; 2
	defb 0xf8,0x10,0x70,0x08,0xf0	; 3
	defb 0x10,0x30,0x50,0xf8,0x10	; 4
	defb 0xf8,0x80,0xf0,0x08,0xf0	; 5
	defb 0x70,0x80,0xf0,0x88,0x70	; 6
	defb 0xf8,0x10,0x20,0x40,0x80	; 7
	defb 0x70,0x88,0x70,0x88,0x70	; 8
	defb 0x70,0x88,0x78,0x08,0x70	; 9
	defb 0x00,0x20,0x00,0x20,0x00	; :
	defb 0x00,0x20,0x00,0x20,0x40	; ;
	defb 0x10,0x20,0x40,0x20,0x10	; <
	defb 0x00,0xf8,0x00,0xf8,0x00	; =
	defb 0x40,0x20,0x10,0x20,0x40	; >
	defb 0x70,0x88,0x30,0x00,0x20	; ?
	defb 0x70,0x88,0xb8,0x80,0x70	; @
	defb 0x70,0x88,0xf8,0x88,0x88	; A
	defb 0xf0,0x88,0xf0,0x88,0xf0	; B
	defb 0x70,0x88,0x80,0x88,0x70	; C
	defb 0xe0,0x90,0x88,0x90,0xe0	; D
	defb 0xf8,0x80,0xf0,0x80,0xf8	; E
	defb 0xf8,0x80,0xf0,0x80,0x80	; F
	defb 0x78,0x80,0xb8,0x88,0x78	; G
	defb 0x88,0x88,0xf8,0x88,0x88	; H
	defb 0x70,0x20,0x20,0x20,0x70	; I
	defb 0xf8,0x08,0x08,0x88,0x70	; J
	defb 0x88,0x90,0xe0,0x90,0x88	; K
	defb 0x80,0x80,0x80,0x80,0xf8	; L
	defb 0x88,0xd8,0xa8,0x88,0x88	; M
	defb 0x88,0xc8,0xa8,0x98,0x88	; N
	defb 0x70,0x88,0x88,0x88,0x70	; O
	defb 0xf0,0x88,0xf0,0x80,0x80	; P
	defb 0x70,0x88,0xa8,0x90,0x68	; Q
	defb 0xf0,0x88,0xf0,0x90,0x88	; R
	defb 0x78,0x80,0x70,0x08,0xf0	; S
	defb 0xf8,0x20,0x20,0x20,0x20	; T
	defb 0x88,0x88,0x88,0x88,0x70	; U
	defb 0x88,0x88,0x88,0x50,0x20	; V
	defb 0x88,0x88,0xa8,0xd8,0x88	; W
	defb 0x88,0x50,0x20,0x50,0x88	; X
	defb 0x88,0x50,0x20,0x20,0x20	; Y
	defb 0xf8,0x10,0x20,0x40,0xf8	; Z
	defb 0x78,0x60,0x60,0x60,0x78	; [
	defb 0x80,0x40,0x20,0x10,0x08	; \
	defb 0xf0,0x30,0x30,0x30,0xf0	; ]
	defb 0x20,0x70,0xa8,0x20,0x20	; ^
	defb 0x00,0x00,0x00,0x00,0xf8	; _
	defb 0x20,0x20,0x10,0x00,0x00	; `
	defb 0x00,0x78,0x88,0x88,0x78	; a
	defb 0x80,0xf0,0x88,0x88,0xf0	; b
	defb 0x00,0x70,0x80,0x80,0x78	; c
	defb 0x08,0x78,0x88,0x88,0x78	; d
	defb 0x00,0x70,0xf8,0x80,0x70	; e
	defb 0x18,0x20,0x78,0x20,0x20	; f
	defb 0x00,0x78,0xf8,0x08,0x70	; g
	defb 0x80,0xf0,0x88,0x88,0x88	; h
	defb 0x20,0x60,0x20,0x20,0x70	; i
	defb 0x08,0x18,0x08,0x08,0x38	; j
	defb 0x80,0x90,0xe0,0x90,0x88	; k
	defb 0x60,0x20,0x20,0x20,0x70	; l
	defb 0x00,0xd0,0xa8,0x88,0x88	; m
	defb 0x00,0xf0,0x88,0x88,0x88	; n
	defb 0x00,0x70,0x88,0x88,0x70	; o
	defb 0x00,0xf0,0x88,0xf0,0x80	; p
	defb 0x00,0x78,0x88,0x78,0x08	; q
	defb 0x00,0xf0,0x88,0x80,0x80	; r
	defb 0x00,0x78,0xe0,0x38,0xf0	; s
	defb 0x20,0x78,0x20,0x20,0x18	; t
	defb 0x00,0x88,0x88,0x88,0x78	; u
	defb 0x00,0x88,0x88,0x50,0x20	; v
	defb 0x00,0x88,0xa8,0xd8,0x88	; w
	defb 0x00,0x88,0x70,0x88,0x88	; x
	defb 0x00,0x88,0x78,0x08,0x70	; y
	defb 0x00,0xf8,0x20,0x40,0xf8	; z
	defb 0x18,0x20,0xc0,0x20,0x18	; {
	defb 0x20,0x20,0x20,0x20,0x20	; |
	defb 0xc0,0x20,0x18,0x20,0xc0	; }
	defb 0x68,0xb0,0x00,0x00,0x00	; ~
        defb 0xf8,0xf8,0xf8,0xf8,0xf8  ; block

