/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.Connection;
import Ice.ConnectionI;
import IceInternal.Transceiver;
import IceSSL.ConnectionInfo;
import IceSSL.ConnectionInvalidException;
import IceSSL.TransceiverI;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class Util {
    public static final String jdkTarget = "1.4";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ConnectionInfo getConnectionInfo(Connection connection) {
        ConnectionI con = (ConnectionI)connection;
        if (!$assertionsDisabled && con == null) {
            throw new AssertionError();
        }
        ConnectionI connectionI = con;
        synchronized (connectionI) {
            Transceiver transceiver = con.getTransceiver();
            if (transceiver == null) {
                ConnectionInvalidException ex = new ConnectionInvalidException();
                ex.reason = "connection closed";
                throw ex;
            }
            try {
                TransceiverI sslTransceiver = (TransceiverI)transceiver;
                return sslTransceiver.getConnectionInfo();
            }
            catch (ClassCastException ex) {
                ConnectionInvalidException e = new ConnectionInvalidException();
                e.reason = "not ssl connection";
                throw e;
            }
        }
    }

    public static X509Certificate createCertificate(String certPEM) throws CertificateException {
        String header = "-----BEGIN CERTIFICATE-----";
        String footer = "-----END CERTIFICATE-----";
        int pos = certPEM.indexOf("-----BEGIN CERTIFICATE-----");
        if (pos == -1) {
            certPEM = "-----BEGIN CERTIFICATE-----\n" + certPEM;
        } else if (pos > 0) {
            certPEM = certPEM.substring(pos);
        }
        if (certPEM.indexOf("-----END CERTIFICATE-----") == -1) {
            certPEM = certPEM + "-----END CERTIFICATE-----";
        }
        byte[] bytes = null;
        try {
            bytes = certPEM.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(in);
    }

    static ConnectionInfo populateConnectionInfo(SSLSocket fd, String adapterName, boolean incoming) {
        ConnectionInfo info = new ConnectionInfo();
        SSLSession session = fd.getSession();
        try {
            info.certs = session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            // empty catch block
        }
        info.cipher = session.getCipherSuite();
        info.localAddr = (InetSocketAddress)fd.getLocalSocketAddress();
        info.remoteAddr = (InetSocketAddress)fd.getRemoteSocketAddress();
        info.adapterName = adapterName;
        info.incoming = incoming;
        return info;
    }

    public static void main(String[] args) {
        System.out.println(jdkTarget);
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

