/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.Catalog;
import Freeze.CatalogData;
import Freeze.Connection;
import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.Map;
import Freeze.NotFoundException;
import Freeze.SharedDbEnv;
import Freeze.Transaction;
import Freeze.Util;
import Ice.Communicator;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.Environment;
import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class SharedDb {
    private Database _db;
    private MapKey _mapKey;
    private String _key;
    private String _value;
    private int _refCount;
    private int _trace;
    private Map.Index[] _indices;
    private static Map _map;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDb get(ConnectionI connection, String dbName, String key, String value, Map.Index[] indices, boolean createDb, Comparator comparator, Map indexComparators) {
        MapKey mapKey = new MapKey(connection.envName(), connection.communicator(), dbName);
        if (dbName.equals(Util.catalogName())) {
            SharedDb result = connection.dbEnv().getCatalog();
            SharedDb.checkTypes(result, key, value);
            ++result._refCount;
            return result;
        }
        Map map = _map;
        synchronized (map) {
            SharedDb result = (SharedDb)_map.get(mapKey);
            if (result == null) {
                try {
                    result = new SharedDb(mapKey, key, value, connection, indices, createDb, comparator, indexComparators);
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDb.errorPrefix(mapKey) + "creation: " + dx.getMessage();
                    throw ex;
                }
                SharedDb previousValue = _map.put(mapKey, result);
                if (!$assertionsDisabled && previousValue != null) {
                    throw new AssertionError();
                }
            } else {
                SharedDb.checkTypes(result, key, value);
                result.connectIndices(indices);
                ++result._refCount;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDb openCatalog(SharedDbEnv dbEnv) {
        MapKey mapKey = new MapKey(dbEnv.getEnvName(), dbEnv.getCommunicator(), Util.catalogName());
        Map map = _map;
        synchronized (map) {
            SharedDb result = (SharedDb)_map.get(mapKey);
            if (result != null) {
                DatabaseException ex = new DatabaseException();
                ex.message = SharedDb.errorPrefix(mapKey) + "Catalog already opened";
                throw ex;
            }
            try {
                result = new SharedDb(mapKey, dbEnv.getEnv());
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                DatabaseException ex = new DatabaseException();
                ex.initCause(dx);
                ex.message = SharedDb.errorPrefix(mapKey) + "creation: " + dx.getMessage();
                throw ex;
            }
            SharedDb previousValue = _map.put(mapKey, result);
            if (!$assertionsDisabled && previousValue != null) {
                throw new AssertionError();
            }
            return result;
        }
    }

    public Database db() {
        return this._db;
    }

    public String dbName() {
        return this._mapKey.dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = _map;
        synchronized (map) {
            if (--this._refCount == 0) {
                Object value = _map.remove(this._mapKey);
                if (!$assertionsDisabled && value != this) {
                    throw new AssertionError();
                }
                if (this._trace >= 1) {
                    this._mapKey.communicator.getLogger().trace("Freeze.Map", "closing Db \"" + this._mapKey.dbName + "\"");
                }
                try {
                    this.cleanupIndices();
                    this._db.close();
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDb.errorPrefix(this._mapKey) + "close: " + dx.getMessage();
                    throw ex;
                }
            }
        }
    }

    protected void finalize() {
        if (!$assertionsDisabled && this._refCount != 0) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private SharedDb(MapKey mapKey, String key, String value, ConnectionI connection, Map.Index[] indices, boolean createDb, Comparator comparator, Map indexComparators) throws com.sleepycat.db.DatabaseException {
        block22: {
            this._refCount = 0;
            this._mapKey = mapKey;
            this._indices = indices;
            this._trace = connection.trace();
            Connection catalogConnection = Util.createConnection(this._mapKey.communicator, connection.dbEnv().getEnvName());
            try {
                Catalog catalog = new Catalog(catalogConnection, Util.catalogName(), true);
                CatalogData catalogData = (CatalogData)catalog.get(this._mapKey.dbName);
                if (catalogData != null) {
                    if (catalogData.evictor) {
                        DatabaseException ex = new DatabaseException();
                        ex.message = SharedDb.errorPrefix(this._mapKey) + "is not an evictor";
                        throw ex;
                    }
                    this._key = catalogData.key;
                    this._value = catalogData.value;
                    SharedDb.checkTypes(this, key, value);
                } else {
                    this._key = key;
                    this._value = value;
                }
                try {
                    Transaction tx = catalogConnection.beginTransaction();
                    com.sleepycat.db.Transaction txn = Util.getTxn(tx);
                    DatabaseConfig config = new DatabaseConfig();
                    config.setAllowCreate(createDb);
                    config.setType(DatabaseType.BTREE);
                    if (comparator != null) {
                        config.setBtreeComparator(comparator);
                    }
                    if (this._trace >= 1) {
                        this._mapKey.communicator.getLogger().trace("Freeze.Map", "opening Db \"" + this._mapKey.dbName + "\"");
                    }
                    this._db = connection.dbEnv().getEnv().openDatabase(txn, mapKey.dbName, null, config);
                    if (this._indices != null) {
                        for (int i = 0; i < this._indices.length; ++i) {
                            Comparator indexComparator = null;
                            if (indexComparators != null) {
                                indexComparator = (Comparator)indexComparators.get(this._indices[i].name());
                            }
                            this._indices[i].associate(mapKey.dbName, this._db, txn, createDb, indexComparator);
                        }
                    }
                    if (catalogData == null) {
                        catalogData = new CatalogData();
                        catalogData.evictor = false;
                        catalogData.key = key;
                        catalogData.value = value;
                        catalog.put(this._mapKey.dbName, catalogData);
                    }
                    tx.commit();
                    Object var18_22 = null;
                }
                catch (Throwable throwable) {
                    Object var18_23 = null;
                    Transaction tx = catalogConnection.currentTransaction();
                    if (tx != null) {
                        try {
                            tx.rollback();
                        }
                        catch (DatabaseException de) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                Transaction tx = catalogConnection.currentTransaction();
                if (tx != null) {
                    try {
                        tx.rollback();
                    }
                    catch (DatabaseException de) {}
                }
                break block22;
                {
                    catch (FileNotFoundException dx) {
                        this.cleanupIndices();
                        NotFoundException ex = new NotFoundException();
                        ex.initCause(dx);
                        ex.message = SharedDb.errorPrefix(this._mapKey) + "Db.open: " + dx.getMessage();
                        throw ex;
                    }
                    catch (com.sleepycat.db.DatabaseException dx) {
                        this.cleanupIndices();
                        DatabaseException ex = new DatabaseException();
                        ex.initCause(dx);
                        ex.message = SharedDb.errorPrefix(this._mapKey) + "Db.open: " + dx.getMessage();
                        throw ex;
                    }
                }
            }
            finally {
                catalogConnection.close();
            }
        }
        this._refCount = 1;
    }

    private SharedDb(MapKey mapKey, Environment dbEnv) throws com.sleepycat.db.DatabaseException {
        this._refCount = 0;
        this._mapKey = mapKey;
        this._key = "string";
        this._value = "::Freeze::CatalogData";
        this._trace = this._mapKey.communicator.getProperties().getPropertyAsInt("Freeze.Trace.Map");
        if (this._trace >= 1) {
            this._mapKey.communicator.getLogger().trace("Freeze.Map", "opening Db \"" + this._mapKey.dbName + "\"");
        }
        DatabaseConfig config = new DatabaseConfig();
        config.setAllowCreate(true);
        config.setType(DatabaseType.BTREE);
        config.setTransactional(true);
        try {
            this._db = dbEnv.openDatabase(null, mapKey.dbName, null, config);
        }
        catch (FileNotFoundException dx) {
            NotFoundException ex = new NotFoundException();
            ex.initCause(dx);
            ex.message = SharedDb.errorPrefix(this._mapKey) + "Db.open: " + dx.getMessage();
            throw ex;
        }
        this._refCount = 1;
    }

    private void connectIndices(Map.Index[] indices) {
        if (indices != null) {
            if (!($assertionsDisabled || this._indices != null && indices.length == this._indices.length)) {
                throw new AssertionError();
            }
            for (int i = 0; i < indices.length; ++i) {
                indices[i].init(this._indices[i]);
            }
        }
    }

    private void cleanupIndices() {
        if (this._indices != null) {
            for (int i = 0; i < this._indices.length; ++i) {
                this._indices[i].close();
            }
            this._indices = null;
        }
    }

    private static void checkTypes(SharedDb sharedDb, String key, String value) {
        if (!key.equals(sharedDb._key)) {
            DatabaseException ex = new DatabaseException();
            ex.message = SharedDb.errorPrefix(sharedDb._mapKey) + sharedDb.dbName() + "'s key type is " + sharedDb._key + ", not " + key;
            throw ex;
        }
        if (!value.equals(sharedDb._value)) {
            DatabaseException ex = new DatabaseException();
            ex.message = SharedDb.errorPrefix(sharedDb._mapKey) + sharedDb.dbName() + "'s value type is " + sharedDb._value + ", not " + value;
            throw ex;
        }
    }

    private static String errorPrefix(MapKey k) {
        return "Freeze DB DbEnv(\"" + k.envName + "\") Db(\"" + k.dbName + "\"): ";
    }

    static {
        $assertionsDisabled = !SharedDb.class.desiredAssertionStatus();
        _map = new HashMap();
    }

    private static class MapKey {
        final String envName;
        final Communicator communicator;
        final String dbName;
        static final /* synthetic */ boolean $assertionsDisabled;

        MapKey(String envName, Communicator communicator, String dbName) {
            if (!$assertionsDisabled && envName == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && communicator == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && dbName == null) {
                throw new AssertionError();
            }
            this.envName = envName;
            this.communicator = communicator;
            this.dbName = dbName;
        }

        public boolean equals(Object o) {
            try {
                MapKey k = (MapKey)o;
                return this.dbName.equals(k.dbName) && this.communicator == k.communicator && this.envName.equals(k.envName);
            }
            catch (ClassCastException ex) {
                this.communicator.getLogger().trace("Freeze.Map", "equals cast failed");
                return false;
            }
        }

        public int hashCode() {
            return this.dbName.hashCode() ^ this.envName.hashCode() ^ this.communicator.hashCode();
        }

        static {
            $assertionsDisabled = !(class$Freeze$SharedDb == null ? (class$Freeze$SharedDb = SharedDb.class$("Freeze.SharedDb")) : class$Freeze$SharedDb).desiredAssertionStatus();
        }
    }
}

