/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.LocalObjectImpl;
import Ice.Logger;
import Ice.SocketException;
import IceInternal.Network;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public final class SysLoggerI
extends LocalObjectImpl
implements Logger {
    private String _ident;
    private DatagramSocket _socket;
    private InetAddress _host;
    private static int _port = 514;
    private final int LOG_USER = 1;
    private final int LOG_ERR = 3;
    private final int LOG_WARNING = 4;
    private final int LOG_INFO = 6;

    public SysLoggerI(String ident) {
        this._ident = ident;
        try {
            this._host = Network.getLocalAddress();
            this._socket = new DatagramSocket();
            this._socket.connect(this._host, _port);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    public void print(String message) {
        this.log(6, message);
    }

    public void trace(String category, String message) {
        this.log(6, category + ": " + message);
    }

    public void warning(String message) {
        this.log(4, message);
    }

    public void error(String message) {
        this.log(3, message);
    }

    private void log(int severity, String message) {
        try {
            int priority = 8 | severity;
            String msg = '<' + Integer.toString(priority) + '>' + this._ident + ": " + message;
            byte[] buf = msg.getBytes();
            DatagramPacket p = new DatagramPacket(buf, buf.length, this._host, _port);
            this._socket.send(p);
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }
}

