#import "NSMutableArrayTest.h"

#import <Foundation/NSArray.h>

@implementation NSMutableArrayTest

- (void)setUp {
    empty = [[NSMutableArray alloc] init];
    full = [[NSMutableArray alloc] init];
    [full addObject:@"Hello,"];
    [full addObject:@"world!"];
}

- (void)tearDown {
    [empty release];
    [full release];
}

- (void)testCount {
    [self assertInt:[empty count] equals:0];
    [self assertInt:[full count] equals:2];
}

- (void)testAddObject {
    [empty addObject:@"Jeff"];
    [self assertInt:[empty count] equals:1];
    [self assertTrue:[empty containsObject:@"Jeff"] message:@"should contain 'Jeff' string"];
}

- (void)testContainsObject {
    [self assertTrue:[full containsObject:@"world!"] message:@"should contain 'world!' string"];
    [self assertFalse:[empty containsObject:@"world!"] message:@"shouldn't contain 'world!' string"];
}

- (void)testObjectAtIndex {
    [self assert:[full objectAtIndex:1] equals:@"world!"];
}

- (void)testObjectAtIndexRaisesException {
    NSException *exception = nil;

    NS_DURING
        [full objectAtIndex:5];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"should raise exception"];
    [self assertString:[exception name] equals:@"NSRangeException"];
}

- (void)testRemoveAllObjects {
    [empty removeAllObjects];
    [full removeAllObjects];
    [self assertInt:[empty count] equals:0];
    [self assertInt:[full count] equals:0];
}

- (void)testRemoveObject {
    [full removeObject:@"world!"];
    [self assertFalse:[full containsObject:@"world!"] message:@"shouldn't contain 'world!' string anymore"];
}

@end
