##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Miscellanous reference class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import registerType

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields import howpublishedField


howpublishedspecificField = howpublishedField.copy()
howpublishedspecificField.default = 'Misc'
SourceSchema = Schema((
    howpublishedspecificField,
     ))

MiscSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
             SourceSchema + TrailingSchema


class MiscReference(BaseEntry):
    """ content type to make reference to miscellaneous publications.
    """
    security = ClassSecurityInfo()
    archetype_name = "Misc Reference"
    source_fields = ('howpublished',)

    schema = MiscSchema
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default misc source format
        """
        try:
            return self.MiscSource()
        except AttributeError:
            return "Miscellaneous publication."


registerType(MiscReference)
