##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Proceedings reference class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import registerType
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, BooleanField
from Products.Archetypes.public import StringWidget, BooleanWidget

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields \
    import publisherField, addressField, volumeField, numberField, \
           organizationField, seriesField, editor_flagField
from Products.CMFBibliographyAT.content.book \
    import AuthorTrailingSchema

ThisAuthorTrailingSchema = AuthorTrailingSchema.copy()
ThisAuthorTrailingSchema['editor_flag'].default=1
ThisAuthorTrailingSchema['editor_flag'].widget.description='Leave this checked unless the people specified above are not the editors of this proceedings volume.'
ThisAuthorTrailingSchema['editor_flag'].widget.description_msgid='help_editor_flag_checked'

SourceSchema = Schema((
    publisherField,
    addressField,
    volumeField,
    numberField,
    organizationField,
    seriesField,
    ))

ProceedingsSchema = HeaderSchema + AuthorSchema + ThisAuthorTrailingSchema + \
                    CoreSchema + SourceSchema + TrailingSchema


class ProceedingsReference(BaseEntry):
    """ content type to make reference to a book.
    """
    security = ClassSecurityInfo()
    archetype_name = "Proceedings Reference"
    source_fields = ('publisher', 'address', 'volume', 'number', 'organization', 'series')

    schema = ProceedingsSchema
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default proceedings source format
        """
        try:
            return self.ProceedingsSource()
        except AttributeError:
            publisher = self.getPublisher()
            address   = self.getAddress()
            
            source = publisher
            if address: source += ', ' + address
            
            return source + '.'


registerType(ProceedingsReference)
