import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Interface.Verify import verifyClass
from AccessControl import getSecurityManager

from Products.CMFCore.utils import getToolByName

import Products.CMFMember
from Products.CMFMember.tests import CMFMemberTestCase
from Products.CMFMember.tools.memberdatacontainer import MemberDataContainer
from Products.CMFMember.content.member import Member as MemberData

class TestLoginInfoSchema(CMFMemberTestCase.CMFMemberTestCase):

    def testLastLoginTime(self):

        mtool = getToolByName(self.portal, 'portal_membership')

        member = mtool.getAuthenticatedMember()
        member_id = member.getId()

        # grab the last login time (should be 2000/01/01)
        first_login_time = member.getLast_login_time()

        # logout
        self.logout()
        
        # login     
        self.login(member_id)
        self.portal.logged_in()
        if self.ploneIs2_0():
            # lame 2.0 bug
            self.portal.login_success()

        # log them out again
        self.logout()
        
        # log back in and compare        
        self.login(member_id)
        self.portal.logged_in()
        if self.ploneIs2_0():
            # lame 2.0 bug
            self.portal.login_success()
        
        member = mtool.getAuthenticatedMember()
        new_login_time = member.getLast_login_time()
        
        self.assertNotEqual(first_login_time, new_login_time,
                            "last_login_time was not set")

if __name__ == '__main__':
    framework(verbosity=1)
else:
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestLoginInfoSchema))
        return suite

