/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: zorp.h,v 1.39 2004/07/05 07:59:55 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_H_INCLUDED
#define ZORP_H_INCLUDED

#include <Python.h>
#undef ENABLE_IPV6
#include <zorp/zorplibconfig.h>
#include <zorpconfig.h>
#include <glib.h>
#include <zorp/misc.h>
#include <zorp/memtrace.h>

/* return values of callbacks are composed as follows:
 *
 * 0. byte: Error condition
 * 1. byte: action to take
 * 2. byte: undefined
 * 3. byte: undefined
 */


#define ZORP_POLICY_FILE	ZORP_SYSCONFDIR "/policy.py"
#define ZORP_POLICY_BOOT_FILE	ZORP_DATADIR "/policy.boot"
#define ZORP_AUTH_CERT_FILE	ZORP_SYSCONFDIR "/zorp.crt"
#define ZORP_AUTH_KEY_FILE	ZORP_SYSCONFDIR "/zorp.key"
#define ZORP_PID_FILE_DIR       "/var/run/zorp"

#define MAX_SESSION_ID		128

#define CORE_POLICY  "core.policy"

extern GMainLoop *main_loop;
extern gint exit_code;
extern gboolean usr1_received;
extern gboolean usr2_received;

void z_main_loop_initiate_reload(gboolean called_from_sighandler);
gboolean z_main_loop_get_last_reload_result(void);

void z_main_loop_initiate_termination(gboolean called_from_sighandler);

void z_main_loop(const gchar *policy_file, const gchar *instance_name, const gchar **instance_policy_list);
void z_main_loop_quit(int exit_code);
void z_log_set_fake_session_id(const gchar *instance_name G_GNUC_UNUSED);

#endif
