############################################################################
##
## Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: SockAddr.py,v 1.23 2002/04/19 12:41:03 sasa Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.6
## Notes:
##
############################################################################

"""Module implementing SockAddr handling functions.

This module implements inet_ntoa and inet_aton, and provides an interface
to SockAddr services provided by the Zorp core.
"""

from string import split, atoi

#def ntohl(l):
#	pass
#
#def htonl(l):
#	pass
#
#def gethostbyname(h):
#	pass

def inet_aton(ip):
	"""Function to convert an internet address to a 32 bit integer

	This function converts the string representation of an IPv4 address
	to an integer in network byte order.	

	Arguments
	
	  ip -- A dotted-quad string

	Returns
	
	  unsigned long in network byte order
	  
	"""
	# FIXME: there is no parameter check
	parts = split(ip, '.', 4);
	return htonl(atoi(parts[0]) << 24 | \
		     atoi(parts[1]) << 16 | \
		     atoi(parts[2]) << 8  | \
		     atoi(parts[3]))

def inet_ntoa(ip):
	"""Function to convert a 32 bit integer into an IPv4 address.

	This function converts an IP address from network byte order
	into its string representation (dotted quad).
	
	Arguments
	
	  ip   -- The ip number in 32 bit integer (network byte order)
	  
	Returns
	
	  string representation of IP
	"""
	ip = ntohl(ip)
	
	parts = (((ip & 0xff000000) >> 24) & 0xff,
		 (ip & 0x00ff0000) >> 16,
		 (ip & 0x0000ff00) >> 8,
		 (ip & 0x000000ff))
	return "%u.%u.%u.%u" % parts

class SockAddrInet:
	"""Class encapsulating an IPv4 address:port pair.
	
	This class encapsulates an IPv4 address:port pair, similar
	to the struct sockaddr_in in C. It is implemented and
	exported by the Zorp core.
	
	Attributes
	
	  ip  -- ip address (network byte order)
	  
	  ip_s -- ip address in string representation
	  
	  port -- port number (network byte order)
	"""
	pass
	
class SockAddrInetRange:
	"""Builtin class to represent an IPv4 address range.
	
	Specialized SockAddrInet class which allocates a new port
	within the given range of ports when a listener
	bounds to it.
	
	Attributes
	
	  ip -- ip address (network byte order)
	  
	  ip_s -- ip address in string representation
	  
	  port -- port number (network byte order)
	"""


#
#class SockAddr:
#	type = ""
#
#	def __init__(self, type):
#		self.type = type
#	def format(self):
#		raise NotImplementedError	
#
#	def __cmp__(self, other):
#		return -1
#
#class SockAddrInet(SockAddr):
#	ip = 0
#	ip_s = ""
#	port = 0
#	
#	def __init__(self, ip, port):
#		SockAddr.__init__(self, 'inet')
#		self.ip = inet_aton(ip)
#		self.ip_s = ip
#		self.port = port
#
#	def format(self):
#		return "AF_INET(%s:%d)" % (self.ip_s, self.port)
#
#	def __cmp__(self, other):
#		try:
#			if (other.type == self.type and other.ip == self.ip and other.port == self.port):
#				return 0
#		except:
#			return -1
#
#class SockAddrInet6(SockAddr):
#	def __init__(self, ip, port):
#		SockAddr.__init__(self, 'inet6')
#		self.ip = ip
#		self.port = port
#
#class SockAddrUnix(SockAddr):
#	def __init__(self, path):
#		SockAddr.__init__(self, 'unix')
#		self.path = path
#
#	def format(self):
###		return "AF_UNIX(%s)" % (self.path, )
