# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

#FIXME: add dependency on storm/twisted-wrapper

setup(name='elisa-plugin-database',
    version='0.1', 
    description="Database management support",
    long_description="""Scan the media and store it in the database to make it easier""",
    license='UNKNOWN', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf'],
                  'elisa.plugins.database.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                 },
    entry_points="",
    controller_mappings=[
                         # FIXME: we should create a controller path convention
                         # and adapt the pathes here
                         ('/poblesec/database/music/artists',
                          'elisa.plugins.database.music_controller:ArtistsDbListSwitcherController'),
                         ('/poblesec/database/music/albums',
                          'elisa.plugins.database.music_controller:AlbumsDbListSwitcherController'),
                         ('/poblesec/database/music/tracks',
                          'elisa.plugins.database.music_controller:TracksDbListSwitcherController'),
                         ('/poblesec/database/music/genres',
                          'elisa.plugins.database.music_controller:GenresDbListSwitcherController'),
                         ('/poblesec/database/music/genre',
                          'elisa.plugins.database.music_controller:GenreDbListSwitcherController'),
                         ('/poblesec/database/music/decades',
                          'elisa.plugins.database.music_controller:DecadesDbListSwitcherController'),
                         ('/poblesec/database/music/time',
                          'elisa.plugins.database.music_controller:TimeDbListSwitcherController'),
                         ('/poblesec/database/music/tracks_played',
                          'elisa.plugins.database.playlists_controller:PlayedTracksListSwitcherController'),
                         ('/poblesec/database/music/tracks_added',
                          'elisa.plugins.database.playlists_controller:AddedTracksListSwitcherController'),
                         ('/poblesec/database/photo/list',
                          'elisa.plugins.database.photo_controller:PhotoListSwitcherController'),
                         ('/poblesec/database/photo/photo_actions',
                          'elisa.plugins.database.photo_controller:PhotoVerticalWithPreview'),
                         ('/poblesec/database/photo/albums',
                          'elisa.plugins.database.photo_controller:AlbumsListSwitcherController'),
                         ('/poblesec/database/photo/photos_added',
                          'elisa.plugins.database.playlists_controller:AddedPhotosListSwitcherController'),
                         ('/poblesec/database/photo/photos_played',
                          'elisa.plugins.database.playlists_controller:PlayedPhotosListSwitcherController'),
                        ('/poblesec/database/.*playlists',
                          'elisa.plugins.poblesec.section:SectionMenuController'),
                         ('/poblesec/database/.*library',
                          'elisa.plugins.poblesec.section:SectionMenuController'),],
    decorator_mappings=[
                        # FIXME: the filesystem decorator should not be here
                        # but in the poblesec plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/database/music_library',
                        'elisa.plugins.poblesec.music:filesystem_decorator'),
                        # music library entries
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.music_controller:music_lib_decades_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.music_controller:music_lib_genres_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.music_controller:music_lib_tracks_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.music_controller:music_lib_albums_decorator'),
                        ('/poblesec/database/music_library',
                         'elisa.plugins.database.music_controller:music_lib_artists_decorator'),
                        # FIXME: this decorator should not be here but in the
                        # poblesec plugin; this works around an ordering issue
                        # in the menus.
                        ('/poblesec/database/photo_library',
                        'elisa.plugins.poblesec.pictures:filesystem_decorator'),
                        # images
                        ('/poblesec/database/photo_library',
                         'elisa.plugins.database.playlists_controller:recently_added_photos_decorator'),
                        ('/poblesec/database/photo_library',
                         'elisa.plugins.database.playlists_controller:last_played_photos_decorator'),
                        ('/poblesec/database/photo_library',
                         'elisa.plugins.database.photo_controller:photo_lib_albums_decorator'),
                        ('/poblesec/database/photo_library',
                         'elisa.plugins.database.photo_controller:photo_lib_images_decorator'),

                        # playlists
                        ('/poblesec/database/music/playlists',
                         'elisa.plugins.database.playlists_controller:recently_added_tracks_decorator'),
                        ('/poblesec/database/music/playlists',
                         'elisa.plugins.database.playlists_controller:most_played_tracks_decorator'),
                        ('/poblesec/database/music/playlists',
                         'elisa.plugins.database.playlists_controller:last_played_tracks_decorator'),
                       # the scanning widget. Can someone please tell me, that
                        # there is a reg-exp that makes it work much easier?
                        ('/poblesec/database/.*',
                         'elisa.plugins.database.scanning_widget:scanning_decorator'),],
    cmdclass=cmdclass,
)
