# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Benjamin Kampmann <benjamin@fluendo.com>
#          Alessandro Decina <alessandro@fluendo.com>

from twisted.internet import glib2reactor
glib2reactor.install()
from twisted.internet import reactor
from elisa.plugins.gstreamer.amp_protocol import GstMetadataSlaveFactory
from elisa.core.log import Loggable
from elisa.core import log
log.init()

class Runner(Loggable):
    def run(self, cookie, connection_string):
        tokens = connection_string.split(':', 3)
        assert tokens[0] in ('tcp', 'unix')

        if tokens[0] == 'tcp':
            host, port = tokens[1:]

            if not len(host):
                # nothing given means localhost
                host = 'localhost'

            # port needs to be a integer for connectTCP
            port = int(port)

            connector = reactor.connectTCP(host, port,
                    GstMetadataSlaveFactory(cookie))
        else:
            address = tokens[1]
            connector = reactor.connectUNIX(address,
                    GstMetadataSlaveFactory(cookie))

        reactor.run()

def run_slave(cookie, connection_string):
    Runner().run(cookie, connection_string)
