# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest
import sys
import gobject

from pkg_resources import resource_filename

from elisa.plugins.pigment.widgets.theme import Theme
from elisa.plugins.pigment.widgets.const import *
import pgm

class TestTheme(unittest.TestCase):

    def test_init_bare(self):
        theme = Theme()

        self.assertEquals(len(theme.widget_styles.items()), 0)
        self.assertEquals(len(theme.stock_resources.items()), 0)

    def test_init_style(self):
        styles_conf = resource_filename('elisa.plugins.pigment.tests',
                                        'data/widgets/styles.conf')
        theme = Theme(styles_conf=styles_conf)

        self.failIf(len(theme.widget_styles.items()) == 0)
        self.failIf(len(theme.stock_resources.items()) != 0)

    def test_init_resources(self):
        resources_conf = resource_filename('elisa.plugins.pigment.tests',
                                        'data/widgets/resources.conf')
        theme = Theme(resources_conf=resources_conf)

        self.failIf(len(theme.widget_styles.items()) != 0)
        self.failIf(len(theme.stock_resources.items()) == 0)

    def test_update(self):
        styles_conf = resource_filename('elisa.plugins.pigment.tests',
                                        'data/widgets/styles.conf')
        t1 = Theme(styles_conf=styles_conf)
        resources_conf = resource_filename('elisa.plugins.pigment.tests',
                                        'data/widgets/resources.conf')
        t2 = Theme(resources_conf=resources_conf)

        t1.update(t2)

        self.failIf(len(t1.widget_styles.items()) == 0)
        self.failIf(len(t1.stock_resources.items()) == 0)

    def test_merge(self):
        styles_conf = resource_filename('elisa.plugins.pigment.tests',
                                        'data/widgets/styles.conf')
        t1 = Theme(styles_conf=styles_conf)
        resources_conf = resource_filename('elisa.plugins.pigment.tests',
                                        'data/widgets/resources.conf')
        t2 = Theme(resources_conf=resources_conf)

        t3 = t1.merge(t2)

        self.failIf(len(t3.widget_styles.items()) == 0)
        self.failIf(len(t3.stock_resources.items()) == 0)

        t4 = t2.merge(t1)

        self.failIf(len(t4.widget_styles.items()) == 0)
        self.failIf(len(t4.stock_resources.items()) == 0)

    def test_get_style_for_widget(self):
        theme = Theme()

        self.failUnlessEqual(len(theme.fallback_themes), 0)

        style = theme.get_style_for_widget('elisa.plugins.pigment.widgets.Button')

        self.failUnless(style)
        self.failUnlessEqual(len(theme.fallback_themes), 1)
        self.failUnless(theme.fallback_themes.get('elisa.plugins.pigment.widgets'))

        style = theme.get_style_for_widget('elisa.plugins.pigment.widgets.List')

        self.failUnless(style)
        self.failUnless(theme.fallback_themes.get('elisa.plugins.pigment.widgets'))

        # search for a non-existant Widget
        style = theme.get_style_for_widget('elisa.plugins.pigment.widgets.NoWidget')

        self.failIf(style)

        # search for a non-existant module
        style = theme.get_style_for_widget('wwwwwwwww.Widget')

        self.failIf(style)

    def test_get_resource(self):
        theme = Theme()

        self.failUnlessEqual(len(theme.fallback_themes), 0)

        resource = theme.get_resource('elisa.plugins.pigment.widgets.yes')
        path = resource_filename('elisa.plugins.pigment.widgets', 'data/yes.png')

        self.failUnlessEqual(resource, path)
        self.failUnlessEqual(len(theme.fallback_themes), 1)
        self.failUnless(theme.fallback_themes.get('elisa.plugins.pigment.widgets'))

    def test_get_default(self):
        self.failUnless(Theme.get_default())

    def test_set_default(self):
        theme = Theme()

        self.failIf(theme == Theme.get_default())

        Theme.set_default(theme)

        self.failUnlessEqual(theme, Theme.get_default())

