/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment Python binding
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Loïc Molinari <loic@fluendo.com>
 *            Philippe Normand <philippe@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <pygobject.h>
#include <Python.h>
#include <pgm/pgm.h>

void pypgm_register_classes (PyObject *d);
void pypgm_add_constants (PyObject *module, const gchar *strip_prefix);

extern PyMethodDef pypgm_functions[];

DL_EXPORT (void)
init_pgm (void)
{
  PyObject *m, *d;
  PyObject *av;
  int argc, i;
  char **argv;

  m = Py_InitModule ("_pgm", pypgm_functions);
  d = PyModule_GetDict (m);

  init_pygobject ();

  /* pull in arguments */
  av = PySys_GetObject ("argv");
  if (av != NULL)
    {
      argc = PyList_Size (av);
      argv = g_new (char *, argc);
      for (i = 0; i < argc; i++)
        argv[i] = g_strdup (PyString_AsString (PyList_GetItem (av, i)));
    }

  if (!pgm_init_check (&argc, &argv))
    {
      Py_FatalError ("Can't initialize module pgm.");
      return;
    }

  if (argv != NULL)
    {
      PySys_SetArgv (argc, argv);
      for (i = 0; i < argc; i++)
        g_free (argv[i]);
      g_free (argv);
    }

  pypgm_register_classes (d);
  pypgm_add_constants (m, "PGM_");

  if (PyErr_Occurred ())
    Py_FatalError ("Can't initialize module pgm.");

  atexit (pgm_deinit);
}
