/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * In addition, as a special exception, Intel gives permission to link
 * the code of portions of this program with the OpenSSL project's
 * "OpenSSL" library (or with modified versions of it that use the same
 * license as the "OpenSSL" library), and distribute the linked
 * executables.  You must obey the GNU General Public License in all
 * respects for all of the code used other than "OpenSSL".  If you modify
 * this file, you may extend this exception to your version of the file,
 * but you are not obligated to do so.  If you do not wish to do so,
 * delete this exception statement from your version.
 */

#ifndef DCS_POLICY_CONTROL_H
#define DCS_POLICY_CONTROL_H
#include <map>
using namespace std;
#include "DCSCommon.h"
#include "PolicyDef.h"

#ifdef UNIT_TEST
#include "TestPolicy.h"
#endif

#define MODULE_NUM 100
#define EVENT_NUM 20
#define USER_GROUP_NUM 3


//SetPolicy also as one function of module Policy
#define MODULE_POLICY 0
#define FUNCTION_SET_POLICY 0

typedef struct Policy_Operation_S{
	DCS_UserGroup usergroup;
	int moduleId;
	int opId;
}Policy_Operation;

struct less_compare		//overloading operator < in order to use STL map for user-defined type
{
public:
	bool operator()(const Policy_Operation var1,const Policy_Operation var2) const
	{
		if (var1.usergroup == var2.usergroup)
		{
			if (var1.moduleId == var2.moduleId)
				return var1.opId < var2.opId;
			else
				return var1.moduleId < var2.moduleId;
		}
		else
			return var1.usergroup < var2.usergroup;
	}
};

typedef map<Policy_Operation,DCS_Policy_Access,less_compare>Operation_Policies;

class Policy{
#ifdef UNIT_TEST
	friend class TestPolicy;
#endif
protected:
	Policy();

public:
	static Policy* Instance();
	~Policy();
//Init the policies according to the system user group, default value
	int Init();
//UnInit the policies
	int UnInit();
//Check if the client could trigger the function/event 
	DCS_Policy_Access CheckPolicy(DCS_UserGroup userGroup, int moduleId, int op_id);
	//Check if the client could trigger the function/event 
	DCS_Policy_Access CheckPolicy(DCS_UserID userId, int moduleId, int op_id);

//Set the policy, only the Administrator could set policy successfully
/** Adds a new policy rule.
 *
 * @param userGroup	the user group of the new policy
 * @param moduleId	the module ID of the new policy
 * @param opId		the operation ID of the new policy
 * @param access	DCS_POLICY_ALLOWED or DCS_POLICY_REJECTED
 */
	int SetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access access);

/**get the policy to see if one user group has the right to do the operation (op_id) in specified module (module_id)*/
	int GetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access* access);

/**remove the policy with specified user group, module id and operation id*/
	int RemovePolicy(DCS_UserGroup userGroup, int moduleId, int opId);
/**set the default policy, it's automatically set to the default value if the policy is not set.*/
	int SetDefaultPolicy(DCS_Policy_Access access);
/**save the policy info from memory to cfg file */
	int SavePolicy();
private:
	static Policy* m_pInstance;
	DCS_UserGroup m_userGroup;
//	DCS_EncryptID m_encryptID;
	DCS_Policy_Access m_defaultAccess;
	Operation_Policies m_policies;
	DCS_UserGroup GetUserGroup(DCS_UserID userId);

	int LoadPolicy();
	char m_file[MAX_PATH];
};

#endif

