/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifdef WIN32
#include <afxwin.h>
#include <iostream>
#else
#include <stdio.h>              /* for convenience */
#include <pthread.h>
#endif

#include "ConnMgmt.h"
#include "SupplierManager.h"
#include "Policy.h"
#include "Crypto.h"
#include "accel/AccelDef.h"
#include "vkbd/VKbdDef.h"
extern void WINAPI DebugString(const char* format, ...);
void DCS_EventDispatcher(int moduleID, int eventID, PVOID pData, size_t dataLen)
{
	ConnMgmt* pConnMgmt = ConnMgmt::Instance();
	//if (moduleID == 4) //if (moduleID == 2 && eventID == 100)
	{
		DebugString("send out response  moduleID = %d eventID == %d",moduleID, eventID);//, *(PDCS_VKbd_Data)pData);
	}
/*if (moduleID == 2 && eventID == 100){
		PDCS_Accel_Data data = (PDCS_Accel_Data)pData;
		DebugString("accel datalen %d\n", dataLen);
		DebugString("accel data: (%d, %d, %d) \n", data->AccelX,data->AccelY,data->AccelZ);
	}*/
	DCS_Response response;	

	response.dataLen = (int)dataLen;
	if (dataLen > 0)
		response.data = new char[dataLen];
	else
		response.data = NULL;
	response.moduleID = moduleID;
	response.opID = eventID;
	response.returnCode = DCS_SUCCESS;
	if (dataLen > 0)
		if (response.data != NULL)
			memcpy(response.data, pData, dataLen);
	pConnMgmt->SendToAll (&response);
	
	

}

void * ProcessRequest(void *data)
{
	DCS_Socket clifd = (DCS_Socket)data;

	SupplierManager* pSupplierManager = SupplierManager::Instance();
	ConnMgmt* pConnMgmt = ConnMgmt::Instance();
	Policy* pPolicy=Policy::Instance();	
	//int size=0;
	int ret =0;
	//DCS_Request_Type type=DCS_EVENT_REQUEST;
	//int msgID=0;
	PVOID pReturnData = alloca(MAX_RETURN_DATA_LEN);
//	size_t returnDataLen = MAX_RETURN_DATA_LEN;
	size_t returnDataLen = 0;
	DCS_Request request;
	DCS_RequestData reqData;
	LPVOID recvReq=NULL;
	//#ifdef WIN32
	//	if (pConnMgmt->SetSocket(clifd))
	//		return NULL;
	//#endif
	recvReq = (LPVOID)alloca(sizeof(Func_Request));
	DebugString("start to ProcessRequest %ld", clifd);
	while (1)
	{
		memset(&request, 0, sizeof(request));
		if (recvReq != NULL)
			memset(recvReq, 0 , sizeof(Func_Request));
		/** Receive messages and decode messages if needed*/
		DebugString("start to recv request of %ld", clifd);
		if (pConnMgmt->Recv (clifd, &request) != DCS_SUCCESS)
		{ // client already exit
			DebugString("recv error of %ld", clifd);
			ret = DCS_FAIL_OPERATION;
			goto DCS_PROCESSREQUEST_EXIT;
		}
		DebugString("request received and start to handle of %ld", clifd);

		DCS_Response response;	
		switch (request.header.msgType)
		{
		case DCS_UNREGISTER_EVENT_REQUEST:
		case DCS_EVENT_REQUEST:
			DebugString("Event request of %ld", clifd);
			recvReq =&request.request.evt;
			response.moduleID = ((Event_Request*)recvReq)->moduleId;
			response.opID = ((Event_Request*)recvReq)->eventId;
			response.dataLen = 0;
			response.data = NULL;
			DebugString("Event request Start to check policy of %ld", clifd);
			/* check policy to see if the user has the right to do the operation*/
			if (pPolicy->CheckPolicy(request.header.userID, ((Event_Request*)recvReq)->moduleId, ((Event_Request*)recvReq)->eventId) == DCS_POLICY_REJECTED)
			{
				DebugString("Event request denied of %ld", clifd);
				ret = DCS_REQUEST_DENIED;

				response.returnCode =(DCS_Return_Code) ret;
				pConnMgmt->Send (clifd, &response);
				//goto DCS_PROCESSREQUEST_EXIT;
			}
			else
			{
				if (request.header.msgType == DCS_EVENT_REQUEST)
				/* Handle the event*/
					ret = pSupplierManager->HandleEvent(clifd, ((Event_Request*)recvReq)->moduleId, ((Event_Request*)recvReq)->eventId);		
				else
					ret = pSupplierManager->HandleUnregisterEvent(clifd, ((Event_Request*)recvReq)->moduleId, ((Event_Request*)recvReq)->eventId);		
				
			}


			break;
		case DCS_FUNCTION_REQUEST:
			recvReq =&request.request.func;
			response.moduleID = ((Func_Request*)recvReq)->moduleId;
			response.opID = ((Func_Request*)recvReq)->funcId;

			if (pPolicy->CheckPolicy(request.header.userID, ((Func_Request*)recvReq)->moduleId, ((Func_Request*)recvReq)->funcId) == DCS_POLICY_REJECTED)
			{
				ret = DCS_REQUEST_DENIED;
				response.returnCode = (DCS_Return_Code)ret;
				response.dataLen = 0;
				response.data = NULL;
				pConnMgmt->Send (clifd, &response);
				break;
			}

			/** Handle the function request*/
			reqData.cliId = ((Func_Request*)recvReq)->procId;
			reqData.funcId = ((Func_Request*)recvReq)->funcId;	
			reqData.userId = request.header.userID;

			reqData.paramsLen = ((Func_Request*)recvReq)->paramLen;
			if (reqData.paramsLen  > 0)
				reqData.pParams = ((Func_Request*)recvReq)->params;
			else
				reqData.pParams = NULL;
			reqData.pReturnData = pReturnData;
			reqData.pReturnDataLen = returnDataLen;

			ret = pSupplierManager->HandleFuncRequest(clifd, ((Func_Request*)recvReq)->moduleId, &reqData);
			//response.msgID = msgID;

			response.moduleID = ((Event_Request*)recvReq)->moduleId;
			response.opID = ((Event_Request*)recvReq)->eventId;
			response.returnCode = (DCS_Return_Code)ret;
			response.dataLen = (int)reqData.pReturnDataLen;
			if (response.dataLen < 0 || response.dataLen > MAX_RETURN_DATA_LEN)
				response.dataLen = 0;
			if (0 == response.dataLen) {
				response.data = NULL;
			} else {
				response.data = new char[response.dataLen];
				memset(response.data, 0, response.dataLen);
				memcpy(response.data, (char*)pReturnData, response.dataLen);
			}
			pConnMgmt->Send (clifd, &response);
			if (((Func_Request*)recvReq)->params)
				delete []((char*)((Func_Request*)recvReq)->params);

			//	goto DCS_PROCESSREQUEST_EXIT;
			break;
		default:
			ret = DCS_NOT_SUPPORTED;
		}
		//free the memory allocated in request
#ifdef WIN32
		if (request.header.userID)
			delete []request.header.userID;
#endif
	}
DCS_PROCESSREQUEST_EXIT:		
	DebugString("Recv error and quit ProcessRequest");
	pSupplierManager->RemoveClient(clifd);
	pConnMgmt->Disconnect(clifd);
#ifdef WIN32

	//	TerminateThread(handle,0);
	closesocket(clifd);

	return NULL;
#else
	close(clifd); 
	pthread_exit(NULL);
#endif
}
