/****************************************************************************

 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

File Name:          PMDriverMgmt.h

Description:

    This file defines class PMDriverMgmt.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-8-15

  =====================================================================

****************************************************************************/

#ifndef PMDRIVERMGMT_H_INCLUDED
#define PMDRIVERMGMT_H_INCLUDED

#include "PMDriver.h"

#include <iostream>
using namespace std;

class PMDriverMgmt
{
public:
    static PMDriverMgmt* Getinstance();
    int InitializeDriverPath();

    int GetBrightness();
    int SetBrightness(int value);

    int GetWireless();
    int SetWireless(int value);

    int GetLan();
    int SetLan(int value);

    ~PMDriverMgmt();

protected:
    PMDriverMgmt();

private:
    void GetDriverPath();

private:
    static PMDriverMgmt* m_pPMDriverMgmt;
    static char m_pDriverPath[ACPI_MAX_STRING];
    int m_fd;
};


#endif // PMDRIVERMGMT_H_INCLUDED
