/****************************************************************************

Copyright (c) 2008 Intel Corporation.  All rights reserved. 

 

DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 

****************************************************************************/



/**
 * 
 * @file TabletPlugin.cpp
 *
 * @version 0.1
 * @author Christina
 * @date 2008/07/17
 */

#include "plugins/DcsPlugin.h"
#include "plugins/tablet/TabletDef.h"
#include "plugins/tablet/TabletPlugin.h"
#include "TabletHelper.h"

#define TABLET_DESCRIPTION "Tablet Plugin"

#ifdef WIN32

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason,
					LPVOID lpvReserved) {
	switch (fdwReason) {
	case DLL_PROCESS_ATTACH:
		break;

	case DLL_THREAD_ATTACH:
		break;

	case DLL_THREAD_DETACH:
		break;

	case DLL_PROCESS_DETACH:
		break;
	}

	return TRUE;
}

#endif	/** WIN32 */

DCSAPI int DP_GetModuleID()
{
	return DCS_TABLET_SENSOR;
}

DCSAPI const char *DP_GetDescription()
{
	return TABLET_DESCRIPTION;
}

DCSAPI int DP_Initialize(DCS_Funcs *pDispatcher)
{
	return TabletHelper::GetInstance().Initialize(pDispatcher);
}

DCSAPI int DP_Uninitialize()
{
	return TabletHelper::GetInstance().Cleanup();
}

DCSAPI DCS_Return_Code DP_HandleRequest(DCS_RequestData *pRequest)
{
	return TabletHelper::GetInstance().HandleRequest(pRequest);
}

DCSAPI int DP_DestroyClient(int cliId)
{
	return DCS_SUCCESS;
}

