/**
 * 
 * @file VkdHelper.cpp
 *
 * @version 1.0
 * @author Shirley Zhao
 * @date 2008/07/20
 */

#include <assert.h>
#include "VkdHelper.h"

#define dbg_print(format, arg...) \
	printf("%s " format, __func__, ##arg)

#define VKBD_KEY_FNF1_PRESS			0x81
#define VKBD_KEY_FNF8_PRESS			0x82
#define VKBD_KEY_FNF10_PRESS		0x83
#define VKBD_KEY_FNF11_PRESS		0x84
#define VKBD_KEY_BEZEL_PRESS		0x85
#define VKBD_KEY_FNF1_RELEASE		0x91
#define VKBD_KEY_FNF8_RELEASE		0x92
#define VKBD_KEY_FNF10_RELEASE		0x93
#define VKBD_KEY_FNF11_RELEASE		0x94
#define VKBD_KEY_BEZEL_RELEASE		0x95

//#define FNF1_PRESSED		0x81
//#define FNF1_RELEASED		0x91
//#define FNF8_PRESSED		0x82
//#define FNF8_RELEASED		0x92
//#define FNF10_PRESSED		0x83
//#define FNF10_RELEASED	0x93
//#define FNF11_PRESSED		0x84
//#define FNF11_RELEASED	0x94
//#define BZBN_PRESSED		0x85
//#define BZBN_RELEASED		0x95

#define TEST_SIG	0x80
int test_sig = 0;
int timer_count = 0;

#define NO_BZBN_PRESSED		0
#define FIRST_BZBN_PRESSED	1
#define SECOND_BZBN_PRESSED 2

#define	BACKLIGHT_NO		0
#define	BACKLIGHT_DOWN		1
#define BACKLIGHT_UP		2

/** const values */
const char * const VkdHelper::MODULE_NAME = "Freescale MMA7660L";
const char * const VkdHelper::DEVICE_PATH = "/proc/acpi/cmpc_vkd";

#ifndef VKD_TEST
void TestSiglrmHandler(int sig);
void BzbnSiglrmHandler(int sig);
void BacklightSiglrmHandler(int sig);
#endif

void *VkdEventHandler(void *arg)
{
#ifdef VKD_TEST
	DCS_VKbd_Data data;
	while(1)
	{
		sleep(10);
		VkdHelper::GetInstance().DispatchEventToDCS(FN_WLAN_SWITCH);
			
	}
#else																																																																																																																																																																																																																												
	int oprt;

	while (TRUE) 
	{
		read(VkdHelper::GetInstance().m_Device, &oprt, sizeof(int));
		dbg_print("The event is 0x%x\n", oprt);
		VkdHelper::GetInstance().ProcFnkeyMsg(oprt);
	}
#endif
	return NULL;
}

int VkdHelper::Initialize(DCS_Funcs *pDispatcher)
{
	m_Bzbn_Signal = NO_BZBN_PRESSED;
	m_Backlight_Signal = BACKLIGHT_NO;

#ifndef VKD_TEST
	m_Device = open(DEVICE_PATH, O_RDWR | O_SYNC);
	if (-1 == m_Device) {	
		return DCS_FAIL_OPERATION;
	}
#endif
	m_pFuncs = pDispatcher;

	if (pthread_create(&m_Thread, NULL, VkdEventHandler, NULL)) {
		return DCS_FAIL_OPERATION;
	}

	return DCS_SUCCESS;
}

int VkdHelper::Cleanup()
{
	if (-1 != m_Device) {
		close(m_Device);
		m_Device = -1;
	}
	
	if (0 != m_Thread) {	
		if (pthread_join(m_Thread, NULL)) {
			m_Thread = 0;
			return DCS_FAIL_OPERATION;
		}
		m_Thread = 0;
	}

	return DCS_SUCCESS;
}

DCS_Return_Code VkdHelper::HandleRequest(DCS_RequestData *pRequest)
{

	switch (pRequest->funcId) 
	{
	case VKBD_GET_KEY:
		*(int *)(pRequest -> pReturnData) = 1;
		pRequest -> pReturnDataLen = sizeof(int);
		break;
	default:
		return DCS_FUNC_NOTEXIST;
	}
	return DCS_SUCCESS;
}

BOOL VkdHelper::DispatchEventToDCS(DCS_VKbd_Data data)
{
	assert(NULL != VkdHelper::GetInstance().m_pFuncs);
	VkdHelper::GetInstance().m_pFuncs->dispatchEvent(DCS_VIRTUAL_KEY,
		VKBD_KEY_EVENT, &data, sizeof(DCS_VKbd_Data));

	return TRUE;
}

BOOL VkdHelper::ProcFnkeyMsg(int oprt)
{
	switch(oprt)
	{
	case TEST_SIG:
		TestFun();
		break;
	case VKBD_KEY_FNF1_PRESS:
		dbg_print("switch wlan status\n");
		DispatchEventToDCS(FN_WLAN_SWITCH);
		break;

	case VKBD_KEY_FNF1_RELEASE:
		break;

	case VKBD_KEY_FNF8_PRESS:
		dbg_print("switch display\n");
		DispatchEventToDCS(FN_DISPLAY_SWITCH);
		break;

	case VKBD_KEY_FNF8_RELEASE:
		break;

	case VKBD_KEY_FNF10_PRESS:
		SetBacklightDownPressed();
		break;
	case VKBD_KEY_FNF10_RELEASE:
		SetBacklightDownReleased();
		break;
	case VKBD_KEY_FNF11_PRESS:
		SetBacklightUpPressed();
		break;
	case VKBD_KEY_FNF11_RELEASE:
		SetBacklightUpReleased();
		break;
	case VKBD_KEY_BEZEL_PRESS:
		SetBzbnPressed();
		break;
	case VKBD_KEY_BEZEL_RELEASE:
		SetBzbnReleased();
		break;
	default:
		break;
	}	

	return TRUE;
}

void VkdHelper::TestFun()
{
	if(test_sig%2 == 0)
	{
//		SetBzbnPressed();
		SetBacklightDownPressed();
		test_sig ++;
	}	
	else
	{
//		SetBzbnReleased();
		SetBacklightDownReleased();
		test_sig ++;
	}
}

#ifndef VKD_TEST
void TestSiglrmHandler(int sig)
{
	dbg_print("test timer out\n");
	test_sig ++;

	if(test_sig > 5)
	{
		VkdHelper::GetInstance().SetTimer(0,0);
		test_sig = 0;
	}
}

void VkdHelper::SetTimer(int interval, int value)
{        
	struct itimerval itv, oldtv;        
	itv.it_interval.tv_sec = interval;        
	itv.it_interval.tv_usec = 0;        
	itv.it_value.tv_sec = value;        
	itv.it_value.tv_usec = 0;        
	setitimer(ITIMER_REAL, &itv, &oldtv);
}

void BzbnSiglrmHandler(int sig)
{        
	if(	VkdHelper::GetInstance().m_Bzbn_Signal == FIRST_BZBN_PRESSED)
	{
		VkdHelper::GetInstance().SetTimer(0,0);
		VkdHelper::GetInstance().m_Bzbn_Signal = NO_BZBN_PRESSED;
		dbg_print("bzbn single clicked\n");
		VkdHelper::GetInstance().DispatchEventToDCS(BEZELBUTTON_SINGLE_CLICK);
	}
}

void BacklightSiglrmHandler(int sig)
{    
	timer_count ++;

	if(VkdHelper::GetInstance().m_Backlight_Signal == BACKLIGHT_DOWN)
	{
		dbg_print("backlight down pressed\n");
		VkdHelper::GetInstance().DispatchEventToDCS(FN_BRIGHTNESS_DOWN);
	}
	else if(VkdHelper::GetInstance().m_Backlight_Signal == BACKLIGHT_UP)
	{
		dbg_print("backlight up pressed\n");
		VkdHelper::GetInstance().DispatchEventToDCS(FN_BRIGHTNESS_UP);
	}

	if(timer_count >= 7)
	{
		VkdHelper::GetInstance().SetTimer(0,0);
	}
}
#endif

void VkdHelper::SetBzbnPressed()
{
	dbg_print("bzbn pressed\n");
#ifndef VKD_TEST
	if(	m_Bzbn_Signal == NO_BZBN_PRESSED)
	{
		m_Bzbn_Signal = FIRST_BZBN_PRESSED;
	}	
	else if(m_Bzbn_Signal == FIRST_BZBN_PRESSED)
	{
		m_Bzbn_Signal = SECOND_BZBN_PRESSED;
		SetTimer(0,0);
	}
#endif
}

void VkdHelper::SetBzbnReleased()
{
	dbg_print("bzbn released\n");
#ifndef VKD_TEST
	if(	m_Bzbn_Signal == FIRST_BZBN_PRESSED)
	{
		signal(SIGALRM, BzbnSiglrmHandler);        
		SetTimer(1,1);
	}
	else if(m_Bzbn_Signal == SECOND_BZBN_PRESSED)
	{
		dbg_print("bzbn double clicked\n");
		DispatchEventToDCS(BEZELBUTTON_DOUBLE_CLICK);
		m_Bzbn_Signal = NO_BZBN_PRESSED;
	}
#endif
}

void VkdHelper::SetBacklightDownPressed()
{
	m_Backlight_Signal = BACKLIGHT_DOWN;
	dbg_print("backlight down pressed\n");
	DispatchEventToDCS(FN_BRIGHTNESS_DOWN);
#ifndef VKD_TEST
	timer_count = 0;
	signal(SIGALRM, BacklightSiglrmHandler);        
	SetTimer(1,1);	
#endif
}

void VkdHelper::SetBacklightDownReleased(void)
{
	dbg_print("backlight down released\n");
	m_Backlight_Signal = BACKLIGHT_NO;
#ifndef VKD_TEST
	SetTimer(0,0);
	timer_count = 0;
#endif
}

void VkdHelper::SetBacklightUpPressed(void)
{
#ifndef VKD_TEST
	m_Backlight_Signal = BACKLIGHT_UP;
	dbg_print("backlight UP pressed\n");
	DispatchEventToDCS(FN_BRIGHTNESS_UP);

	timer_count = 0;
	signal(SIGALRM, BacklightSiglrmHandler);        
	SetTimer(1,1);	
#endif
}

void VkdHelper::SetBacklightUpReleased(void)
{
	dbg_print("backlight up released\n");
#ifndef VKD_TEST
	m_Backlight_Signal = BACKLIGHT_NO;
	SetTimer(0,0);
	timer_count = 0;
#endif
}
