/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMApplyProfileBalloon.h"
#include "ENMApp.h"
#include "CustomStaticText.h"
#include "ENMTaskTray.h"

#if defined(__WXMSW__)
#include <windows.h>
#endif

const long ENMApplyProfileBalloon::ID_TIMER_APPLYBALLOON = wxNewId();
const long ENMApplyProfileBalloon::ID_BTN_CLOSE = wxNewId();

BEGIN_EVENT_TABLE(ENMApplyProfileBalloon, wxBitmapDialog)
    EVT_TIMER(ID_TIMER_APPLYBALLOON, ENMApplyProfileBalloon::OnTimer)
    EVT_BUTTON(ID_BTN_CLOSE, ENMApplyProfileBalloon::OnButtonClick)
END_EVENT_TABLE()

#if defined(__WXMSW__)
ENMApplyProfileBalloon::ENMApplyProfileBalloon(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic\\bg_applying.png"),wxBITMAP_TYPE_PNG), dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    m_profileName = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(20, 14), wxSize(254, 16), 0, _T("ID_STATICTEXT_PROFILENAME"));
    m_profileName->SetBackgroundColour(wxColour(238, 238, 233));
	m_pGauge = new wxGauge(this, wxID_ANY, 100, wxPoint(20, 54), wxSize(260, 28), 0, wxDefaultValidator, _T("ID_GAUGE_APPLYBALLOON"));
	m_networkType = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(20, 102), wxSize(160, 16), 0, _T("ID_STATICTEXT_NETWORKTYPE"));
	m_networkType->SetBackgroundColour(wxColour(233, 232, 225));
//	m_btnClose = new wxBitmapButton(this, ID_BTN_CLOSE, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\close.png"))), wxPoint(235,8), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BTN_CANCEL"));
	m_btnClose = new wxButton(this, ID_BTN_CLOSE, _("Stop"), wxPoint(190, 95), wxSize(90, 28), 0, wxDefaultValidator, _T("ID_BTN_CLOSE"));
	m_ApplyBalloonTimer.SetOwner(this, ID_TIMER_APPLYBALLOON);
	m_ApplyBalloonTimer.Start(1000);
	m_iCount = 0;
	m_pGauge->SetValue(m_iCount);
	wxPoint finalPos;
    int width = 0;
    int height = 0;
    ::wxDisplaySize(&width, &height);
    finalPos = wxPoint(width - this->GetSize().GetWidth(), height - this->GetSize().GetHeight() - ADJUST_HEIGHT);
	this->Move(finalPos);
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
}
#endif

#if defined(__UNIX__)
ENMApplyProfileBalloon::ENMApplyProfileBalloon(wxWindow* parent, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strImagePath + _T("bg_applying.png"),wxBITMAP_TYPE_PNG),parent, (wxWindowID)wxID_ANY, wxEmptyString)
    , m_ApplyBalloonTimer(this, ID_TIMER_APPLYBALLOON)
{
    int width = GetSize().GetWidth();
    int height = GetSize().GetHeight();
    int margin = 15;

    int x = margin, y = margin;
    m_profileName = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(x, y), wxSize(width - margin * 2, 20));

    y += 20 + margin;
	m_pGauge = new wxGauge(this, wxID_ANY, 100, wxPoint(x, y), wxSize(width - margin * 2, 30));

	wxSize btnSize(80, 30);

	y = height - btnSize.GetHeight() - margin;
	m_networkType = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(x, y + 5), wxSize(width - btnSize.GetWidth() - margin * 3, 20));

	x = width - btnSize.GetWidth() - margin;
	m_btnClose = new wxButton(this, ID_BTN_CLOSE, _("Stop"), wxPoint(x, y), btnSize);

	m_ApplyBalloonTimer.Start(1000);
	m_iCount = 0;
	m_pGauge->SetValue(m_iCount);

    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos(clientRect.GetWidth() - width, 0);
	this->SetPosition(finalPos);
}
#endif

ENMApplyProfileBalloon::~ENMApplyProfileBalloon()
{
}

void ENMApplyProfileBalloon::OnTimer(wxTimerEvent& event)
{
    if ( m_iCount < 100 )
    {
        m_iCount += 10;
        m_pGauge->SetValue(m_iCount);
    }
    else
    {
        m_iCount = 0;
    }
}

void ENMApplyProfileBalloon::StopTimer()
{
    m_ApplyBalloonTimer.Stop();
}

void ENMApplyProfileBalloon::CallExit()
{
    m_pGauge->SetValue(m_pGauge->GetRange());
    wxThread::Sleep(20);
    m_ApplyBalloonTimer.Stop();
    this->Show(false);
}

void ENMApplyProfileBalloon::SetApplyProfileName(wxString wxsProfileName)
{
    wxsProfileName.Replace(_T("&"), _T("&&"));
    m_profileName->SetLabel(_("Applying ") + wxsProfileName);
    m_profileName->SetForegroundColour(wxColor(0, 0, 255));
    wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_profileName->SetFont(StaticText1Font);
	wxSize size = m_profileName->GetSize();
	//wxMessageBox(wxString::Format(wxT("%d:%d"), size.GetWidth(), size.GetHeight()));
	if ( size.GetWidth() > 260 )
	{
	    wxString strFirst = wxsProfileName.Mid(0, 10);
	    m_profileName->SetLabel(_("Applying ") + strFirst + _T("..."));
	}
}

void ENMApplyProfileBalloon::SetTurningOnNetwork(wxString wxsNetworkType)
{
    m_networkType->SetLabel(_("Turning on ") + wxsNetworkType + _("..."));
}

//void ENMApplyProfileBalloon::SetGaugeCount(int iPostion)
//{
//    m_iCount = iPostion;
//}

void ENMApplyProfileBalloon::OnButtonClick(wxCommandEvent& event)
{
//    CallExit();
    ENMTaskTray::GetInstance()->StopApplyConnecting();
}

