/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef FILETAR_H
#define FILETAR_H

#include <wx/wx.h>
#include <wx/file.h>

#define TAR_MAX_FILES 1024
#define NBUFFSIZE 8092
#define _MAX_FNAME 256
#define _MAX_PATH 260

#define NNChar unsigned long

class FileTar
{
    protected:
        struct TarIndex
        {
            long Start;
            long Size;
            NNChar FileName[_MAX_FNAME];
            NNChar Description[256];
        };

        class TarHeader
        {
        private:
            NNChar TarDescription[512];
            int FileCount;
        public:
            // Set file count =0
            TarHeader();

            // Increase filecount
            int IncrementCount();

            // Get file count
            int GetCount();

            // Get description
            wxString GetDescription();

            // Set description
            bool SetDescription(const wxString& strdesc);
        };

    public:
        FileTar();
        virtual ~FileTar();
        // Untar tarfile to a given path
        static int UnTar(const wxString& TarFile, const wxString& dpath);

        // Read the content of file[index] and untar it
        static int UnTar(const wxString& TarFile, int index, const wxString& fpathconst
                        , const long fstart, const long fsize);

        // Read file information
        static int GetFileInfo(const wxString& TarFile, TarIndex *pTarIndex, int index);

        // Read tarfile header
        static int GetTarInfo(const wxString& TarFile,TarHeader *pTarHeader);

        // Set description
        bool SetHeaderDescription(const wxString& strdesc);

        // Get description
        wxString GetHeaderDescription();

        // Create tarfile to Tarpath
        int CreateTar(const wxString& TarFName, const wxString& TarPath);

        // Add the file and get the attribute of file, such as filename, filesize
        int AddFile(const wxString& fname, const wxString& desc);

        // Set the file path
        void SetFilePath(const wxString& path);

    private:
        TarHeader m_TarHeader;
        TarIndex* m_pTarIndex[TAR_MAX_FILES];
        NNChar FilePath[_MAX_PATH];
        static const long SIGNATURE;
};

#endif // FILETAR_H
