/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ProfileOtherSettings.h"
#include "CustomStaticText.h"
#include "ENMApp.h"
#include "ENMUtil.h"
#include "NetSecrityDlg.h"
#include "AutoRunSettings.h"
#include "IPSettings.h"
#include "ProxySettings.h"

const long ProfileOtherSettings::ID_PROXYCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_HPCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_IPCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_APPCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_NSCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_SET3BUTTON = wxNewId();
const long ProfileOtherSettings::ID_SET4BUTTON = wxNewId();
const long ProfileOtherSettings::ID_SET2BUTTON = wxNewId();
const long ProfileOtherSettings::ID_SET1BUTTON = wxNewId();
const long ProfileOtherSettings::ID_HPTEXTCTRL = wxNewId();

BEGIN_EVENT_TABLE(ProfileOtherSettings, wxWizardPageSimple)
	EVT_CHECKBOX(ID_NSCHECKBOX, ProfileOtherSettings::Onm_cbNetworkSecrityClick)
	EVT_CHECKBOX(ID_APPCHECKBOX, ProfileOtherSettings::Onm_cbAppClick)
	EVT_CHECKBOX(ID_IPCHECKBOX, ProfileOtherSettings::Onm_cbDefaultClick)
	EVT_CHECKBOX(ID_HPCHECKBOX, ProfileOtherSettings::Onm_cbHomePageClick)
	EVT_CHECKBOX(ID_PROXYCHECKBOX, ProfileOtherSettings::Onm_cbProxyClick)
	EVT_BUTTON(ID_SET1BUTTON, ProfileOtherSettings::Onm_Set1Click)
	EVT_BUTTON(ID_SET2BUTTON, ProfileOtherSettings::Onm_Set2Click)
	EVT_BUTTON(ID_SET3BUTTON, ProfileOtherSettings::Onm_Set3Click)
	EVT_BUTTON(ID_SET4BUTTON, ProfileOtherSettings::Onm_Set4Click)
    EVT_INIT_DIALOG(ProfileOtherSettings::OnInit)
END_EVENT_TABLE()

ProfileOtherSettings::ProfileOtherSettings(wxWizard* wizard)
        : wxWizardPageSimple(wizard), m_pWizard(wizard)
{
    int width = 530, height = 290;
    int margin = 10;
    SetSize(width, height);

    wxBitmap bmpTitle(::wxGetApp().strImagePath + _T("step1.png"), wxBITMAP_TYPE_PNG);
    m_sbPic = new wxStaticBitmap(this, wxID_ANY, bmpTitle, wxPoint(0, 0), wxDefaultSize);
	m_textOs = new CustomStaticText(this, wxID_ANY, _("Other Settings"), wxPoint(5, 5), wxDefaultSize);
	wxFont m_textOsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textOs->SetFont(m_textOsFont);
	m_textDes3 = new CustomStaticText(this, wxID_ANY, _("Configure other settings of the network"), wxPoint(margin, 30), wxSize(width - margin * 2, 18));
	m_lineSt3 = new wxStaticLine(this, wxID_ANY, wxPoint(0, bmpTitle.GetHeight()), wxSize(width, 1), wxLI_HORIZONTAL);

    wxSize btnSize(140, 28);
    wxSize labelSize(270, 20);
    int e = (btnSize.GetHeight() - labelSize.GetHeight()) / 2;
    int x = margin, y = bmpTitle.GetHeight() + margin;
	m_checkboxNs = new wxCheckBox(this, ID_NSCHECKBOX, _("Network Security"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_checkboxNs->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonSet1 = new wxButton(this, ID_SET1BUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonSet1->Enable(false);

    x = margin;
    y += btnSize.GetHeight() + margin;
	m_checkboxApp = new wxCheckBox(this, ID_APPCHECKBOX, _("Automatically enable applications"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_checkboxApp->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonSet2 = new wxButton(this, ID_SET2BUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonSet2->Enable(false);

    x = margin;
    y += btnSize.GetHeight() + margin;
	m_checkboxIP = new wxCheckBox(this, ID_IPCHECKBOX, _("Overwrite default TCP/IP and DNS"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_checkboxIP->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonSet3 = new wxButton(this, ID_SET3BUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonSet3->Enable(false);

    x = 5;
    y += btnSize.GetHeight() + margin;
#if defined(__WXMSW__)
	m_staticboxBrowser = new wxStaticBox(this, wxID_ANY, _("Customize Internet Explorer"), wxPoint(x, y), wxSize(width - x * 2, height - y - margin));
#else
	m_staticboxBrowser = new wxStaticBox(this, wxID_ANY, _("Customize Firefox Browser"), wxPoint(x, y), wxSize(width - x * 2, height - y - margin));
#endif

    x = margin;
    y += margin * 2 + 5;
	m_checkboxHp = new wxCheckBox(this, ID_HPCHECKBOX, _("Overwrite homepage"), wxPoint(x, y + 3), labelSize, wxALIGN_CENTER_VERTICAL);
	m_checkboxHp->SetValue(false);
	x += labelSize.GetWidth() + margin;
    m_textHp = new wxTextCtrl(this, ID_HPTEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin * 2, 26));
	m_textHp->Enable(false);
	m_textHp->SetEditable(false);

    x = margin;
    y += 26 + margin;
	m_checkboxProxy = new wxCheckBox(this, ID_PROXYCHECKBOX, _("Overwrite proxy configuration"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_checkboxProxy->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonSet4 = new wxButton(this, ID_SET4BUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonSet4->Enable(false);


}

ProfileOtherSettings::~ProfileOtherSettings()
{
}

void ProfileOtherSettings::Onm_cbNetworkSecrityClick(wxCommandEvent& event)
{
    m_buttonSet1->Enable(m_checkboxNs->IsChecked());
}

void ProfileOtherSettings::Onm_cbAppClick(wxCommandEvent& event)
{
    m_buttonSet2->Enable(m_checkboxApp->IsChecked());
}

void ProfileOtherSettings::Onm_cbDefaultClick(wxCommandEvent& event)
{
    m_buttonSet3->Enable(m_checkboxIP->IsChecked());
}

void ProfileOtherSettings::Onm_cbProxyClick(wxCommandEvent& event)
{
    m_buttonSet4->Enable(m_checkboxProxy->IsChecked());
}

void ProfileOtherSettings::Onm_Set1Click(wxCommandEvent& event)
{
    NetSecrityDlg netSecurityDlg(m_pWizard);
    netSecurityDlg.SetNetworkSecuritySetting(m_securitySet);
    if ( netSecurityDlg.ShowModal() == wxID_OK )
    {
        m_securitySet = netSecurityDlg.GetNetworkSecuritySetting();
    }
}

void ProfileOtherSettings::Onm_Set2Click(wxCommandEvent& event)
{
    wxArrayString as;
    for ( vector<wxString>::size_type i = 0; i < m_strAppPath.size(); i++ )
    {
        wxString strAppName = m_strAppPath.at(i);
        as.Add(m_strAppPath.at(i));
    }
    AutoRunSettings autoRunDlg(m_pWizard);
    autoRunDlg.SetApplications(as);
    if( autoRunDlg.ShowModal() == wxID_OK )
    {
        wxArrayString strApps = autoRunDlg.GetApplications();
        m_strAppPath.clear();
        for( size_t i = 0; i < strApps.GetCount(); i++ )
        {
            wxString strAppName = strApps.Item(i);
            m_strAppPath.push_back(strAppName);
        }
    }
}

void ProfileOtherSettings::Onm_Set3Click(wxCommandEvent& event)
{
    IPSettings ipDlg(m_pWizard);
    ipDlg.SetIPSetting(m_ipSet);
    if( ipDlg.ShowModal() == wxID_OK )
    {
        m_ipSet = ipDlg.GetIPSetting();
    }
}

void ProfileOtherSettings::Onm_Set4Click(wxCommandEvent& event)
{
    ProxySettings proxyDlg(m_pWizard);
    proxyDlg.m_TcProxy->SetValue(m_strProxy);
    proxyDlg.m_TcPort->SetValue(m_strPort);
    if( proxyDlg.ShowModal() == wxID_OK )
    {
        m_strProxy = proxyDlg.m_TcProxy->GetValue();
        m_strPort = proxyDlg.m_TcPort->GetValue();
    }
    else
    {
        proxyDlg.m_TcProxy->SetValue(m_strProxy);
        proxyDlg.m_TcPort->SetValue(m_strPort);
    }
}

void ProfileOtherSettings::Onm_cbHomePageClick(wxCommandEvent& event)
{
	m_textHp->Enable(m_checkboxHp->IsChecked());
	m_textHp->SetEditable(m_checkboxHp->IsChecked());
}

void ProfileOtherSettings::SetProfileType(ADAPTER_TYPE adapterType)
{
    bool isWireless = (adapterType == ADAPTER_WIREDLESS);
    m_checkboxNs->Enable(isWireless);
    if ( !m_checkboxNs->IsEnabled() )
    {
        m_checkboxNs->SetValue(false);
    }
    m_buttonSet1->Enable(isWireless && m_checkboxNs->IsChecked());
}

OtherSettings_t ProfileOtherSettings::GetProfileOtherSetting()
{
    OtherSettings_t otherSetting;
    if( m_checkboxNs->IsChecked() )
    {
        otherSetting.NetworkSecurity = _T("1");
    }
    else
    {
        otherSetting.NetworkSecurity = _T("0");
    }

    if( m_checkboxApp->IsChecked() )
    {
        otherSetting.AutoRunAppFlag = _T("1");
    }
    else
    {
        otherSetting.AutoRunAppFlag = _T("0");
    }

    if( m_checkboxIP->IsChecked() && ENMUtil::ValidateIPSettings(m_ipSet) )
    {
        otherSetting.IPDNSFlag = _T("1");
    }
    else
    {
        otherSetting.IPDNSFlag = _T("0");
    }

    if( m_checkboxHp->IsChecked() )
    {
        otherSetting.IsHomepage = _T("1");
    }
    else
    {
        otherSetting.IsHomepage = _T("0");
    }

    if( m_checkboxProxy->IsChecked() )
    {
        otherSetting.ProxyFlag = _T("1");
    }
    else
    {
        otherSetting.ProxyFlag = _T("0");
    }

    otherSetting.stNetSecurity = m_securitySet;

    wxString currentHomePage = m_textHp->GetValue();
    currentHomePage = currentHomePage.Trim(true).Trim(false);
    otherSetting.Homepage = currentHomePage;

    otherSetting.stIPDNSSet = m_ipSet;

    otherSetting.stProxySet.Proxy = m_strProxy;
    otherSetting.stProxySet.Port = m_strPort;

    otherSetting.AutoRunApp = m_strAppPath;

    return otherSetting;
}

bool ProfileOtherSettings::ValidateHomepage() const
{
    wxString strHomepage = m_textHp->GetValue().Trim(false).Trim(true);
    if ( m_checkboxHp->IsChecked() && strHomepage.Length() > 0 )
    {
        return strHomepage.IsAscii();
    }
    else
    {
        return true;
    }
}

void ProfileOtherSettings::OnInit(wxInitDialogEvent& event)
{

}
