/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENExistBalloon.h"
#include "ENMApp.h"

BEGIN_EVENT_TABLE(ENExistBalloon, wxBitmapDialog)
END_EVENT_TABLE()

ENExistBalloon::ENExistBalloon(wxWindow* parent)
    : wxBitmapDialog(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("Shape_balloon.png"))), parent, wxEmptyString)
{
    wxBitmap bmpTip(::wxGetApp().strImagePath + _T("tip.png"), wxBITMAP_TYPE_PNG);
    int width = GetSize().GetWidth();
    int height = GetSize().GetHeight();
    int margin = 15;
    wxSize stxSize(width - bmpTip.GetWidth() - margin * 3, height - margin * 2);
    staticBitmap1 = new wxStaticBitmap(this, wxID_ANY, bmpTip, wxPoint(margin, margin));
    title1 = new wxStaticText(this, wxID_ANY, _("Easy Network is running. You can click Easy Network tray icon to use it."), wxPoint(bmpTip.GetWidth() + margin * 2, margin), stxSize);
    title1->SetForegroundColour(wxColour(20, 80, 190));
    title1->Wrap(stxSize.GetWidth());

    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos(clientRect.GetWidth() - width - margin + clientRect.x, margin + clientRect.y);
    this->Move(finalPos);
}

ENExistBalloon::~ENExistBalloon()
{

}


