/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_TASKTRAY_H_
#define _ENM_TASKTRAY_H_

#include <wx/utils.h>
#include <wx/bitmap.h>
#include <wx/event.h>
#include <wx/timer.h>
#include "wx/taskbar.h"
#include "ENMApplyProfileBalloon.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "TaskBarBalloon.h"
#include "TaskBarBalloonLAN.h"
#include "DisConnectBalloon.h"
#include "WlanScanner.h"
#include "ProfileEditor.h"
#include "WirelessEvent.h"
#include <vector>
#include "ENExistBalloon.h"

class ENMTaskTray: public wxTaskBarIcon
{
public:
    //get instance
    static ENMTaskTray* GetInstance();
    //init
    void init(bool AutoRun);
    //set task icon
    void SetTaskbarIcon(NETWORK_MODE networkMode, UI_NETWORK_STATUS_INFO& statusInfo);
    //apply wireless profile
    void ApplyWirelessProfile();
    //set wireless flag
    void SetApplyWirelessFlag(bool bFlag);
    //checking notification area exists or not
    static bool IsProtocolSupported();
    //get wireless flag
    bool GetApplyWirelessFlag();
    //stop apply wireless dlg
    void StopApplyWirelessDlg();
    //waiting for switch
    void SetWaitingForSwitch(bool wait);
    //apply wired profile
    void ApplyWiredProfile();
    //set apply wired flag
    void SetApplyWiredFlag(bool bFlag);
    //get apply wired flag
    bool GetApplyWiredFlag();
    //stop apply conncection process
    void StopApplyConnecting();
    //destrutructor
    virtual ~ENMTaskTray();
    ENExistBalloon* m_notificationDlg;
    wxTimer* m_notificationtimer;

    void HideShownBalloon();

protected:
    static const long ID_TIMER_ENMTASKTRAY;
    static const long ID_TIMER_CLICK;
    static const long ID_TIMER_TICK;
    static const int ID_NOTI_TIMER;

private:
    //constructor
    ENMTaskTray();
    //call when mouse over
    void OnMouseOver(wxTaskBarIconEvent&);
    //call when left button up
    void OnLeftButtonUp(wxTaskBarIconEvent&);
    //call when right button up
    void OnRightButtonUp(wxTaskBarIconEvent&);
    wxMenu *CreatePopupMenu();
    //on timer tick
    void OnTimerTick(wxTimerEvent & event);
    //wlan event
    void OnWlanAcmEvent(WlanAcmEvent& event);
    //timer event
    void ClickTimeEvent(wxTimerEvent & event);
    //profile changed event
    void OnProfileChangedEvent(ProfileEvent& event);
    //wireless switch event
    void OnWirelessSwitchEvent(const WirelessSwitchEvent& event);
    //call when adapter switch
    void OnAdapterSwitched(SwitchAdapterEvent& event);
    //close notification
    void CloseNotification(wxTimerEvent & event);
    //show menu
    void ShowMenu();

    static ENMTaskTray* instance;

    TaskBarBalloon* balloon;
    TaskBarBalloonLAN* m_balloonLAN;
    DisConnectBalloon* disconBalloon;
    ENMApplyProfileBalloon* eNMApplyProfileBalloon;
    ENMApplyProfileBalloon* m_ApplyWirelessProfileBalloon;
    ENMApplyProfileBalloon* m_ApplyWiredProfileBalloon;
    wxTimer * timer;
    wxTimer m_clickTimer;
    bool m_bDoubleClick;

    vector<ProfileList_t> m_vProfiles;
    int iVector;
    APStatus* m_ap;
    NETWORK_INFO* m_netInfo;
    bool bApplyFinish;
    wxPoint m_MousePos;
    bool m_NotifiArea;
    bool bApplyWirelessFinish;
    bool bApplyWiredFinish;
    bool m_isWaitingForSwitch;

    DECLARE_EVENT_TABLE()

};

#endif // _ENM_TASKTRAY_H_
