/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ICON_POSITION_CALCULATOR_H
#define _ICON_POSITION_CALCULATOR_H

#include <wx/gdicmn.h>
#include "wlan.h"

const size_t CIRCLE_COUNT = 5;
const int CIRCLE_AP_COUNT[CIRCLE_COUNT] = {8, 7, 8, 7, 8};
const int POSITION[5][10][3] =
{
    { {415,  24,  5}, {424,  74,  4}, {431, 124,  2}, {434, 174,  1}, {434, 224,  1}, {431, 274,  2}, {424, 324,  4}, {415, 374,  5} },
    { {344,  49, 11}, {351,  99, 11}, {356, 149, 11}, {357, 199, 11}, {356, 249, 11}, {351, 299, 11}, {344, 349, 11}, {  0,   0,  0} },
    { {257,  24, 11}, {266,  74, 11}, {273, 124, 11}, {276, 174, 11}, {276, 224, 11}, {273, 274, 11}, {266, 324, 11}, {257, 374, 11} },
    { {186,  49, 11}, {193,  99, 11}, {198, 149, 11}, {199, 199, 11}, {198, 249, 11}, {193, 299, 11}, {186, 349, 11}, {  0,   0,  0} },
    { { 99,  24, 11}, {108,  74, 11}, {115, 124, 11}, {118, 174, 11}, {118, 224, 11}, {115, 274, 11}, {108, 324, 11}, { 99, 374, 11} }
};

class IconPositionCalculator : public wxObject
{
    public:
        //ctor
        IconPositionCalculator();
        //dtor
        virtual ~IconPositionCalculator();
        //calculate position
        bool CalculatePosition(const APStatus& ap, wxPoint& pos, int* charsOfLabel = NULL);
        //reset
        void Reset();

    private:
        int circleButtonCount[CIRCLE_COUNT];
};

#endif // _ICON_POSITION_CALCULATOR_H
