/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_EVENT_H
#define _PROFILE_EVENT_H

#include <wx/event.h>

const unsigned int ID_PROFILE_EVENT_LOWEST          = wxID_HIGHEST + 0x00A0;

const unsigned int ID_PROFILE_CHANGED               = ID_PROFILE_EVENT_LOWEST + 1;
const unsigned int ID_PROFILE_APPLY                 = ID_PROFILE_EVENT_LOWEST + 2;

const unsigned long PROFILE_EVENT_CODE_LOWEST       = wxID_HIGHEST + 0x0100;

const unsigned long PEVT_CURRENT_PROFILE_CHANGED    = PROFILE_EVENT_CODE_LOWEST + 1L;
const unsigned long PEVT_PROFILE_ADD                = PROFILE_EVENT_CODE_LOWEST + 2L;
const unsigned long PEVT_PROFILE_DELETE             = PROFILE_EVENT_CODE_LOWEST + 3L;
const unsigned long PEVT_PROFILE_EDIT               = PROFILE_EVENT_CODE_LOWEST + 4L;

const unsigned long PEVT_PROFILE_APPLY_SUCCESS      = PROFILE_EVENT_CODE_LOWEST + 5L;
const unsigned long PEVT_PROFILE_APPLY_FAILED       = PROFILE_EVENT_CODE_LOWEST + 6L;
const unsigned long PEVT_PROFILE_APPLY_CONTINUE     = PROFILE_EVENT_CODE_LOWEST + 7L;
const unsigned long PEVT_PROFILE_APPLY_DISCONNECT   = PROFILE_EVENT_CODE_LOWEST + 8L;
const unsigned long PEVT_PROFILE_APPLY_REAPPLY      = PROFILE_EVENT_CODE_LOWEST + 9L;

BEGIN_DECLARE_EVENT_TYPES()
DECLARE_EVENT_TYPE(EVT_PROFILE, -1)
END_DECLARE_EVENT_TYPES()

class ProfileEvent : public wxEvent
{
    public:
        ProfileEvent(unsigned int id = 0, unsigned long code = 0);
        virtual ~ProfileEvent();
        virtual wxEvent* Clone() const;
        virtual unsigned long GetEventCode() const;

    private:
        const int m_iCode;
};

typedef void (wxEvtHandler::*ProfileEventFunction)(ProfileEvent&);

#define EVT_PROFILE(id, fn) DECLARE_EVENT_TABLE_ENTRY( EVT_PROFILE, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( ProfileEventFunction, & fn ), (wxObject*) NULL ),

#endif // _PROFILE_EVENT_H
