Name "FBReader for Classmate PC"

OutFile "FBReaderCMPCSetup-@VERSION@.exe"

InstallDir $PROGRAMFILES\FBReader
InstallDirRegKey HKCU "Software\FBReader" ""

Page directory
Page components
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

Section "FBReader"
	SectionIn RO

	SetOutPath "$INSTDIR"

	WriteRegStr HKCU "Software\FBReader" "" $INSTDIR

	File /oname=FBReader.exe bin/FBReader
	File ../../libs/win32/*.*
	File /r share
  Delete "$INSTDIR\libiconv-2.dll"
  Delete "$INSTDIR\share\FBReader\help\MiniHelp.fb2"
  Delete "$INSTDIR\share\FBReader\hyphenationPatterns.zip"

  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FBReader for Classmate PC" "DisplayName" "FBReader for Classmate PC"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FBReader for Classmate PC" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FBReader for Classmate PC" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FBReader for Classmate PC" "NoRepair" 1
  WriteUninstaller "uninstall.exe"

  CreateDirectory "$SMPROGRAMS\FBReader for Classmate PC"
  CreateShortCut "$SMPROGRAMS\FBReader for Classmate PC\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\FBReader for Classmate PC\FBReader.lnk" "$INSTDIR\FBReader.exe" "" "$INSTDIR\FBReader.exe" 0

	ReadRegStr $0 HKCU "Software\FBReader\options\Options" "BookPath"
	StrCmp $0 "" 0 +2
	WriteRegStr HKCU "Software\FBReader\options\Options" "BookPath" "C:\Books;$PROFILE\Books" 
	ReadRegStr $0 HKCU "Software\FBReader\options\Options" "DownloadDirectory"
	StrCmp $0 "" 0 +2
	WriteRegStr HKCU "Software\FBReader\options\Options" "DownloadDirectory" "$PROFILE\Books" 
	WriteRegStr HKCU "Software\FBReader\options\PlatformOptions" "TouchScreenPresented" "true" 
	WriteRegStr HKCU "Software\FBReader\options\PlatformOptions" "MousePresented" "true" 
	WriteRegStr HKCU "Software\FBReader\options\PlatformOptions" "KeyboardPresented" "true" 
	WriteRegStr HKCU "Software\FBReader\options\Options" "KeyDelay" "0" 
	WriteRegStr HKCU "Software\FBReader\options\SmallScrolling" "ScrollingDelay" "true" 
	WriteRegStr HKCU "Software\FBReader\options\LargeScrolling" "ScrollingDelay" "true" 
	WriteRegStr HKCU "Software\FBReader\options\TapScrolling" "Enabled" "false" 
SectionEnd

Section "Create Shortcut on Desktop"
  CreateShortCut "$DESKTOP\FBReader.lnk" "$INSTDIR\FBReader.exe" "" "$INSTDIR\FBReader.exe" 0
SectionEnd

Section "Uninstall"
	ClearErrors
	Delete "$INSTDIR\FBReader.exe"
	IfErrors 0 ContinueUninstallation
		MessageBox MB_OK "Cannot uninstall FBReader while the program is running.$\nPlease quit FBReader and try again."
		Quit
	ContinueUninstallation:
	RMDir /r "$INSTDIR\share"
	Delete "$INSTDIR\*.dll"
	Delete "$INSTDIR\*.license"
	Delete "$INSTDIR\uninstall.exe"
	RMDir "$INSTDIR"

	RMDir /r "$SMPROGRAMS\FBReader for Classmate PC"
  Delete "$DESKTOP\FBReader.lnk"

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\FBReader for Classmate PC"
	DeleteRegKey /ifempty HKCU "Software\FBReader"

	MessageBox MB_YESNO "Delete FBReader configuration from registry?" IDNO Skip
		DeleteRegKey HKCU "Software\FBReader"
	Skip:
SectionEnd
