#!/usr/bin/python
# .+
#
# .identifier :	$Id: setup.py,v 0.1 2006/02/23 14:38:29 fabrizio Exp $
# .context    : portio python extension
# .title      : distutils setup
# .kind	      : python source
# .author     : Fabrizio Pollastri <pollastri@iriti.cnr.it>
# .site	      : Torino - Italy
# .creation   :	16-Feb-2006
# .copyright  :	(c) 2006 Fabrizio Pollastri
# .license    : GNU General Public License (see .copying below)
#
# .copying
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
# 
# .-

from distutils.core import setup, Extension
import os
import os.path
import re
import string
import sys

classifiers = """\
Development Status :: 3 - Alpha
Intended Audience :: Developers
License :: OSI Approved :: GNU General Public License (GPL)
Programming Language :: Python
Topic :: System :: Hardware
Topic :: Software Development :: Libraries :: Python Modules
Operating System :: POSIX :: Linux
"""

if sys.version_info < (2, 3):
  _setup = setup
  def setup(**kwargs):
    if kwargs.has_key("classifiers"):
      del kwargs["classifiers"]
    _setup(**kwargs)

# if python docutils are installed, generate HTML documentation.
if os.path.exists('/usr/share/python-docutils/buildhtml.py'):
  os.system('/usr/share/python-docutils/buildhtml.py')

readme = open('README.txt').read()	# read in documentation file
readme = string.replace(readme,'**','')	# remove restructuredtext markup

# split documentation by text titles and put each title and its text body
# into a dictionary: title is the key, text body is the value.
readme_split = re.split('\n(.*?)\n====+?\n\n',readme)
i =  3
readme_db = {}
while i < len(readme_split):
  readme_db[readme_split[i]] = readme_split[i + 1]
  i += 2

main_title = readme_split[1] + '\n'	# main title goes alone

# if not present, generate portio.c source file.
# Replace template tag "DOCUMENTATION" into C source with documentation
# text read from README. Add backslash iand new line at end of each line
# (C multiline string syntax).
if not os.path.exists('portio.c'):
  doc = main_title + '\n' + readme_db["Module reference"]
  doc = string.replace(doc,'\n','\\n\\\n')
  source = open('portio.c.in').read()
  source = source % {'DOCUMENTATION':doc}
  open('portio.c','w').write(source)

module = Extension(
  'portio',
  define_macros = [('MAJOR_VERSION', '0'),('MINOR_VERSION', '1')],
  include_dirs = ['/usr/local/include'],
  libraries = [],
  library_dirs = ['/usr/lib'],
  sources = ['portio.c'])

setup (
  name = 'portio',
  version = '0.1',
  author = 'Fabrizio Pollastri',
  author_email = 'pollastri@iriti.cnr.it',
  maintainer = 'Fabrizio Pollastri',
  maintainer_email = 'pollastri@iriti.cnr.it',
  url = 'http://portio.iriti.cnr.it',
  license = 'http://www.gnu.org/licenses/gpl.txt',
  platforms = ['Linux'],
  description = main_title,
  classifiers = filter(None, classifiers.split("\n")),
  long_description =  readme_db["Module reference"],
  ext_modules = [module])

#### end
