/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.


File Name:       testpmdriver.c

Description:
    This file contains how to check the button click event , which receives the 
    message to click button.The driver makes use of Linux char device drvier
    frame and timer to poll the register of gpio[8]. After found a whole 
    message clicking button, this driver will inform Daemon by asynchronous 
    event (async).    

Environment (opt):
    OS: Ubuntu ,Linux kernel 2.6.24
    SE: GCC 3.4.4 

Notes (opt):
    

  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================
  0.1        Create                         wuyunbo      2008-08-06
  =====================================================================

****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <linux/ioctl.h>

#define ACPI_MAX_STRING 80
#include "cmpc_pm.h"

#define DEVICE "/dev/ipml_pm"

#define ACPI_TYPE_DEVICE                0x06	/* Name, multiple Node */
#define ACPI_TYPE_PROCESSOR             0x0C	/* Name,byte_const,Dword_const,byte_const,multi nm_o */
#define ACPI_TYPE_THERMAL               0x0D	/* Name, multiple Node */
#define ACPI_TYPE_POWER                 0x0B	/* Name,byte_const,word_const,multi Node */
typedef unsigned int u32;
#define u8 unsigned char
typedef u32 acpi_integer;
#define ACPI_TYPE_INTEGER               0x01	/* Byte/Word/Dword/Zero/One/Ones */
typedef u32 acpi_object_type;
typedef void *acpi_handle;	/* Actually a ptr to a NS Node */
typedef u32 acpi_io_address;
union acpi_object {
	acpi_object_type type;	/* See definition of acpi_ns_type for values */
	struct {
		acpi_object_type type;
		acpi_integer value;	/* The actual number */
	} integer;

	struct {
		acpi_object_type type;
		u32 length;	/* # of bytes in string, excluding trailing null */
		char *pointer;	/* points to the string value */
	} string;

	struct {
		acpi_object_type type;
		u32 length;	/* # of bytes in buffer */
		u8 *pointer;	/* points to the buffer */
	} buffer;

	struct {
		acpi_object_type type;
		u32 fill1;
		acpi_handle handle;	/* object reference */
	} reference;

	struct {
		acpi_object_type type;
		u32 count;	/* # of elements in package */
		union acpi_object *elements;	/* Pointer to an array of ACPI_OBJECTs */
	} package;

	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} processor;

	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} power_resource;
};

/*
 * Blatantly copied from acpi source code in the kernel
 */
u32
acpi_ut_dword_byte_swap(u32 value) {
	union {
		u32	value;
		u8	bytes[4];
	} out;

	union {
		u32	value;
		u8	bytes[4];
	} in;

	in.value = value;
	out.bytes[0] = in.bytes[3];
	out.bytes[1] = in.bytes[2];
	out.bytes[2] = in.bytes[1];
	out.bytes[3] = in.bytes[0];

	return (out.value);
}

static const char acpi_gbl_hex_to_ascii[] = {'0','1','2','3','4','5','6','7',
                                             '8','9','A','B','C','D','E','F'};

char
acpi_ut_hex_to_ascii_char(acpi_integer integer, u32 position) {
	return (acpi_gbl_hex_to_ascii[(integer >> position) & 0xF]);
}

void
acpi_ex_eisa_id_to_string(u32 numeric_id, char *out_string) {
	u32	eisa_id;

	/* Swap ID to big-endian to get contiguous bits */
	eisa_id = acpi_ut_dword_byte_swap (numeric_id);

	out_string[0] = (char) ('@' + (((unsigned long) eisa_id >> 26) & 0x1f));
	out_string[1] = (char) ('@' + ((eisa_id >> 21) & 0x1f));
	out_string[2] = (char) ('@' + ((eisa_id >> 16) & 0x1f));
	out_string[3] = acpi_ut_hex_to_ascii_char ((acpi_integer) eisa_id, 12);
	out_string[4] = acpi_ut_hex_to_ascii_char ((acpi_integer) eisa_id, 8);
	out_string[5] = acpi_ut_hex_to_ascii_char ((acpi_integer) eisa_id, 4);
	out_string[6] = acpi_ut_hex_to_ascii_char ((acpi_integer) eisa_id, 0);
	out_string[7] = 0;
}

/*
 * evaluate _HID object, only know how to handle integer _HIDs right now
 */
void
get_hid(int fd, char *path, char *hid)
{
	cmpc_pm_acpi_t		data;
	union acpi_object	eisa_id;

	memset(hid, 0, 8);
	memset(&data, 0, sizeof(data));

	strcpy(data.pathname, path);

	if (ioctl(fd, CMPC_PM_ACPI_EVALUATE_OBJ, &data))
		return;

	if (data.status != sizeof(eisa_id)) {
		sprintf(hid, "BUG:sz");
		return;
	}

	if (read(fd, &eisa_id, data.status) != data.status)
		return;

	if (eisa_id.type != ACPI_TYPE_INTEGER) {
		sprintf(hid, "BUG:typ");
		return;
	}
	acpi_ex_eisa_id_to_string(eisa_id.integer.value, hid);

	return;
}

/*
 * This probably has bugs, it's whole purpose is to get
 * the right associativity lines.
 */
void
indent(int *entries, int level)
{
	int i;

	for (i = 0 ; i < level - 1; i++) {
		if (entries[i + 1] > 1)
			printf("|   ");
		else
			printf("    ");
	}

	if (entries[level] > 1)
		printf("|-- ");
	else if (entries[level] == 1)
		printf("`-- ");
}

int
get_brightness(int fd, char* path)
{
	cmpc_pm_acpi_t		data;

	memset(&data, 0, sizeof(data));
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_GET_BRIGHTNESS, &data))
		return 0;
	
	return 	data.status;
}

int
set_brightness(int fd, char* path, int value)
{
	cmpc_pm_acpi_t		data;	
	memset(&data, 0, sizeof(data));
	data.inputparam = value;
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_SET_BRIGHTNESS, &data))
		return 0;
	
	return 	data.status;
}

int
get_wireless(int fd, char* path)
{
	cmpc_pm_acpi_t		data;

	memset(&data, 0, sizeof(data));
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_GET_WIRELESS, &data))
		return 0;
	
	return 	data.status;
}

int
set_wireless(int fd, char* path, int value)
{
	cmpc_pm_acpi_t		data;
	
	memset(&data, 0, sizeof(data));
	data.inputparam = value;
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_SET_WIRELESS, &data))
		return 0;

	return 	data.status;
}

int
get_landevice(int fd, char* path)
{
	cmpc_pm_acpi_t		data;

	memset(&data, 0, sizeof(data));
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_GET_LAN, &data))
		return 0;

	return 	data.status;
}

int
set_landevice(int fd, char* path, int value)
{
	cmpc_pm_acpi_t		data;
	
	memset(&data, 0, sizeof(data));
	data.inputparam = value;
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_SET_LAN, &data))
		return 0;

	return 	data.status;
}

/*int
get_cardreader(int fd, char* path)
{
	cmpc_pm_acpi_t		data;

	memset(&data, 0, sizeof(data));
	strcpy(data.pathname, path);
	if (ioctl(fd, CMPC_PM_ACPI_GET_CARDREADER, &data))
		return 0;

	return 	data.status;
}*/

/*
 * Do we consider this path a file or directory?
 */
int
is_dev(int fd, char *path)
{
	cmpc_pm_acpi_t	data;

	memset(&data, 0, sizeof(data));

	strcpy(data.pathname, path);

	if (ioctl(fd, CMPC_PM_ACPI_GET_TYPE, &data))
		return 0;

	switch (data.status) {
		case ACPI_TYPE_DEVICE:
		case ACPI_TYPE_PROCESSOR:
		case ACPI_TYPE_THERMAL:
		case ACPI_TYPE_POWER:
			return 1;
		default:
			return 0;
	}
}

/*
 * Print out a "directory" and recurse through sub-dirs
 */
void
get_path(int fd, char *path, int *entries, int level, char *pRetPath)
{
	cmpc_pm_acpi_t	data;
	int		i, cnt;
	char		*buf, *tmp, *tmp2;

	memset(&data, 0, sizeof(data));

	if (path)
		strcpy(data.pathname, path);

	if (ioctl(fd, CMPC_PM_ACPI_GET_NEXT, &data)) {
		return;
	}

	buf = (char*)malloc(data.status);

	if (!buf) {
		printf("failed to malloc get_next buffer at %s\n", path);
		return;
	}

	if (read(fd, buf, data.status) != data.status) {
		printf("short read at %s\n", path);
		return;
	}

	tmp = buf;
	for (cnt = 0; (tmp = strchr(tmp, '\n')) != NULL ; cnt++)
		tmp++;

	entries[level] = cnt;

	tmp = buf;
	for (i = 0 ; i < cnt ; i++) {	   
		unsigned long len;
		char *new_path, *cur_obj, hid[8];

		tmp2 = strchr(tmp, '\n');

		len = (unsigned long)tmp2 - (unsigned long)tmp;
		cur_obj = (char*)malloc(len + 1);

		if (!cur_obj) {
			free(buf);
			return;
		}
		memset(cur_obj, 0, len + 1);
		strncpy(cur_obj, tmp, len);

		tmp = tmp2 + 1;

		if (path)
			len += strlen(path) + 1;

		new_path = (char*)malloc(len);

		if (!new_path) {
			free(buf);
			return;
		}
		memset(new_path, 0, len);

		if (path) {
			strcat(new_path, path);
			strcat(new_path, ".");
		}
		strcat(new_path, cur_obj);

		if (is_dev(fd, new_path))
		{
			//indent(entries, level);
			//printf("%s\n", cur_obj);
			get_path(fd, new_path, entries, level + 1, pRetPath);
		}
		else
		{
			if (!strcmp(cur_obj, "_HID") && strstr(new_path, "IPML") )
			{
				get_hid(fd, new_path, hid);
				memset(pRetPath, 0, ACPI_MAX_STRING);
                strcpy( pRetPath , new_path);
                //printf("pRetPath   : %s \n", pRetPath);
				break;
			}
		}
		
		entries[level]--;
		free(new_path);
		free(cur_obj);
	}
}

int
main (int argc, char **argv)
{
	int		fd;
	int		entries[ACPI_MAX_STRING] = {0};
	char buf[ACPI_MAX_STRING];
	memset(buf, 0, ACPI_MAX_STRING);

	fd = open(DEVICE, O_RDONLY);

	if (fd < 0) {
		printf("Error opening file\n");
		return 1;
	}
	
	get_path(fd, NULL, entries, 1, buf);
	
	set_brightness(fd, buf, 4);
	set_wireless(fd, buf, 1);
	set_landevice(fd, buf, 1);
		
	close(fd);
	return 0;
}
