/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMApp.cpp

Description:

    This file implements class PMApp.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/



#include <wx/file.h>
#include "include/PMApp.h"
#include "include/BatteryInfoMgmtProxy.h"
#include "include/PowerSchemeMgmtProxy.h"
#include "include/PMGlobalConstant.h"
#include "include/PMUtility.h"
#include "include/PMTrayIcon.h"

#include "DCSApi.h"

IMPLEMENT_APP(PMApp);

static const int NOTI_TIMER_ID = 10001;

BEGIN_EVENT_TABLE(PMApp, wxApp)
   // EVT_PAINT(PMBalloonWnd::OnPaint)
   // EVT_LEFT_DOWN(PMBalloonWnd::OnClick)
   EVT_TIMER(NOTI_TIMER_ID, PMApp::CloseNotification)
END_EVENT_TABLE()

bool PMApp::OnInit()
{
    exit = false;
    //check DCS
    if (0 != DCS_Initialize())
    {
        return false;
    }

    m_taskBarIcon = NULL;
    m_notificationtimer = NULL;
    m_notificationDlg = NULL;

    int langCode = wxLocale::GetSystemLanguage();
    wxString resource;
    PMUtility::GetLocaleFileName(langCode, resource);
    //wxMessageBox(resource);
    //wxMessageBox(wxString::Format(wxT("ret: %d"), iRet));
    // Load localizated string resource
//    if ( !m_locale.Init(wxLANGUAGE_ARABIC_LIBYA, wxLOCALE_CONV_ENCODING) )
//    {
//        wxLogError(_T("This language is not supported by the system."));
//        return false;
//    }

    m_locale.AddCatalogLookupPathPrefix(RESOURCE_DIR);

    wxString filePath = RESOURCE_DIR + wxT("/") + resource + wxT(".mo");

   // wxMessageBox(filePath);

    if (wxFileExists(filePath))
    {
        m_locale.AddCatalog(resource);
    }
    else
    {
        m_locale.AddCatalog(wxT("en"));
    }

    //check dependencies
    if (!CheckPicPath())
    {
        wxLogError(_("The pictures for power management have been removed!"));
        return false;
    }

    if (!CheckConfigFiles())
    {
        wxLogError(_("The configure files for power management have been removed!"));
        return false;
    }

    //check autostart
    int isAutoStart = 0;
    ConfigurationFileEditor fileEditor;
    fileEditor.GetAutoStart(isAutoStart);


    if (2 == argc && 0 == isAutoStart)
    {
        return false;
    }

    //initial DCS
    m_pngHandler = new wxPNGHandler();
    wxImage::AddHandler(m_pngHandler);

//    PopupNotification();

    //check singleton instance
    if (!PMUtility::GetLock())
    {
        if(PMTrayIcon::IsProtocolSupported())
        {
            //noticafication->Show(true);
            //wxMessageBox(wxT("test"));
          //  wxSleep(6);
          PopupNotification();
          exit = true;
           return true;
        }
        else
        {
            system("/etc/ipower-management/startup.sh");
            return false;
        }
    }
    else {

    m_taskBarIcon = new PMTrayIcon(argc == 2);


    if (NULL != m_taskBarIcon)
    {
        m_taskBarIcon->Init();
    }
    else
    {
        return false;
    }
    PopupNotification();

    PowerSchemeMgmtProxy::GetInstance()->InitScheme();

    m_taskBarIcon->StartIdleTimer();

    return true;
    }
}

int PMApp::OnExit()
{
    if (m_taskBarIcon != NULL)
    {
        delete m_taskBarIcon;
        m_taskBarIcon = NULL;
    }
    if (m_pngHandler != NULL)
    {
        wxImage::RemoveHandler(m_pngHandler->GetName());
       // delete m_pngHandler;
        m_pngHandler = NULL;
    }

    DCS_Uninitialize();

    return EXIT_SUCCESS;
}

bool PMApp::CheckPicPath()
{
    return wxDirExists(PIC_PATH.c_str());
}

bool PMApp::CheckConfigFiles()
{
    wxString homeDir = wxGetHomeDir();
    wxString ipmPath = homeDir + wxT("/.ipm/");
    wxString optionFile = ipmPath + wxT("Options.xml");
    wxString schemeFile = ipmPath + wxT("PowerScheme_pmsch.xml");

    if (!wxDirExists(ipmPath.c_str()))
    {
        if(!wxMkdir(ipmPath))
        {
            return false;
        }
    }

    if (!wxFileExists(optionFile))
    {
        wxString optionFileBak = BAK_CONFIG_FILE_PATH + wxT("Options.xml");
        if (wxFileExists(optionFileBak))
        {
            if(!wxCopyFile(optionFileBak, optionFile, false))
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    if (!wxFileExists(schemeFile))
    {
        wxString schemeFileBak = BAK_CONFIG_FILE_PATH + wxT("PowerScheme_pmsch.xml");
        if (wxFileExists(schemeFileBak))
        {
            if(!wxCopyFile(schemeFileBak, schemeFile, false))
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }

    return true;
}

void PMApp::PopupNotification()
{

    if (NULL == m_notificationDlg)
    {
        m_notificationDlg = new PMBalloonWnd(NULL, wxT("balloon"));
        m_notificationDlg->PopupNotification();
    //    m_notificationDlg->Show(false);
        m_notificationDlg->Show(true);

    }
    if (NULL == m_notificationtimer)
    {
        m_notificationtimer = new wxTimer(this, NOTI_TIMER_ID);
    }

    m_notificationtimer->Start(3000, wxTIMER_ONE_SHOT);
}

void PMApp::CloseNotificationHandler()
{
   if (NULL != m_notificationDlg)
    {
        m_notificationDlg->Show(false);
        delete m_notificationDlg;
        m_notificationDlg = NULL;
    }

    if (NULL != m_notificationtimer)
    {

        m_notificationtimer->Stop();
        delete m_notificationtimer;
        m_notificationtimer = NULL;
    }
    if ( exit )
    {
        ::wxExit();
    }
}

void PMApp::CloseNotification(wxTimerEvent & event)
{
    CloseNotificationHandler();
}
