/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMBalloonWnd.cpp

Description:

    This file implements class PMBalloonWnd.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#include "include/PMBalloonWnd.h"
#include "include/PMGlobalConstant.h"

const int WIDTH = 250;
const int HEIGHT = 100;

static const int NOTI_TIMER_ID = 10001;

BEGIN_EVENT_TABLE(PMBalloonWnd, wxBitmapDialog)
   // EVT_PAINT(PMBalloonWnd::OnPaint)
   // EVT_LEFT_DOWN(PMBalloonWnd::OnClick)
//   EVT_TIMER(NOTI_TIMER_ID, PMBalloonWnd::CloseNotification)
END_EVENT_TABLE()

PMBalloonWnd::PMBalloonWnd(wxWindow *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(PIC_PATH + wxT("Shape_balloon.png"),wxBITMAP_TYPE_PNG), dlg, wxID_ANY, wxEmptyString), m_notificationtimer(this, NOTI_TIMER_ID)
{

}

PMBalloonWnd::~PMBalloonWnd()
{
}

void PMBalloonWnd::InitStatusBalloon()
{
    DCS_Battery_Info batteryInfo;

    wxFont font(12, wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    wxFont font2(9, wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    int index = 0;
    bool res = BatteryInfoMgmtProxy::PM_GetBatteriesInfo(&batteryInfo, index);



    int ac_adapter = BatteryInfoMgmtProxy::PM_GetACAdapterStatus();

    int isAC = 0;

    if (ac_adapter == 1)
    {
        isAC = 1;
    }

    if (!res)
    {
        staticBitmap1 = new wxStaticBitmap(this, wxID_ANY,  wxBitmap(wxImage(PIC_PATH + _T("AC_Power.png"),wxBITMAP_TYPE_PNG)), wxPoint(-6, -6));
        title1 = new wxStaticText(this, wxID_ANY, _("AC Power"), wxPoint(80, 15), wxDefaultSize);
        title1->SetForegroundColour(wxColour(20, 80, 190));
        //font.SetUnderlined(true);
        font.SetWeight(wxFONTWEIGHT_BOLD);
        title1->SetFont(font);
        title2 = new wxStaticText(this, TIME_REMAININF, _("No system battery."), wxPoint(80, 40), wxDefaultSize);
        title2->SetFont(font2);
    }
    else
    {
        wxBitmap bmp;
        title1 = new wxStaticText(this, CAPACITY_REMAINING, wxT(""), wxPoint(80, 15), wxDefaultSize);
        title2 = new wxStaticText(this, TIME_REMAININF, wxT(""), wxPoint(80, 40), wxDefaultSize);
        wxString label = wxEmptyString;
        wxString time = wxEmptyString;

        int remPer = 0;
        if (batteryInfo.RemainPercent != INVALID_VALUE && batteryInfo.RemainPercent <= BAT_FULL_CAP)
        {
            remPer = batteryInfo.RemainPercent;
        }

        if (ac_adapter == 1)
        {
            if (remPer < 100)
            {
                bmp = wxBitmap(wxImage(PIC_PATH + _T("blCharging.png"),wxBITMAP_TYPE_PNG));
                label = _("Charging ") + wxString::Format(wxT("%d%%"), remPer);
                if (batteryInfo.RemainTime == INVALID_VALUE)
                {
                    time = _("Unknown time");
                }
                else if (batteryInfo.RemainTime > BAT_OVER_TIME)
                {
                    wxString ws = _("hours remaining");
                    time = wxT("04:28 ") + ws;
                }
                else
                {
                    time = wxString::Format(wxT("%02d:%02d"), batteryInfo.RemainTime / 60, batteryInfo.RemainTime % 60) + wxT(" ") + _("hours remaining");
                }
            }
            else
            {
                label = _("AC Power");
                time = _("Battery Fully Charged");
                bmp = wxBitmap(wxImage(PIC_PATH + _T("AC_Power.png"),wxBITMAP_TYPE_PNG));
                //wxFont font(9, wxFONTFAMILY_DEFAULT, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_BOLD);
                //font2.SetWeight(wxFONTWEIGHT_BOLD);
                //title2->SetFont(font2);
            }

            title1->SetForegroundColour(wxColour(20, 80, 190));
        }

        if (ac_adapter == 2)
        {
                int percent = remPer;
                if (percent >= 96 && percent <= 100)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("96-100_G.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 86 && percent < 96)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("86-95_G.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 76 && percent < 86)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("76-85_G.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 61 && percent < 76)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("61-75_G.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 51 && percent < 61)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("51-60_G.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 41 && percent < 51)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("41-50_O.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 31 && percent < 41)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("31-40_O.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 21 && percent < 31)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("21-30_O.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 11 && percent < 21)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("11-20_O.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent >= 1 && percent < 11)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("1-10_R.png"),wxBITMAP_TYPE_PNG));
                }
                else if (percent <= 0)
                {
                    bmp = wxBitmap(wxImage(PIC_PATH + _T("Empty.png"),wxBITMAP_TYPE_PNG));
                }

                if (percent < 30)
                {
                    title1->SetForegroundColour(wxColour(wxT("red")));
                }
                else
                {
                    title1->SetForegroundColour(wxColour(20, 80, 190));
                }

            label = _("Battery ") + wxString::Format(wxT("%d%%"), remPer);
            if (batteryInfo.RemainTime == INVALID_VALUE)
            {
                time = _("Unknown time");
            }
            else
            {
                time = wxString::Format(wxT("%02d:%02d"), batteryInfo.RemainTime / 60, batteryInfo.RemainTime % 60) + wxT(" ") + _("hours remaining");
            }
        }

        title1->SetLabel(label);

        staticBitmap1 = new wxStaticBitmap(this, wxID_ANY, bmp, wxPoint(-6, -6));
        //font.SetUnderlined(true);
        font.SetWeight(wxFONTWEIGHT_BOLD);
        title1->SetFont(font);

        title2->SetLabel(time);
        title2->SetFont(font2);
    }

    vector<string> devicesVec;
    int schemeId = 0;
    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(schemeId);
    PowerSchemeMgmtProxy::GetInstance()->GetDisabledDevices(schemeId, isAC, devicesVec);
    if (devicesVec.size() != 0)
    {

        title3 = new wxHyperlinkCtrl(this, LINK, _("Device(s) disabled>>"), wxT(""),wxPoint(95, 65), wxDefaultSize);
        title3->SetBackgroundColour(wxColour(226, 226, 223));
        title3->Connect(LINK, wxEVT_LEFT_UP, (wxObjectEventFunction)&PMBalloonWnd::OnClickToList);
        title3->SetNormalColour(wxColour(19, 80, 192));
        title3->SetHoverColour(wxColour(wxT("blue")));
    }
    MovePosition();
}


void PMBalloonWnd::InitDeviceListBalloon(int alert)
{
    staticBitmap1 = new wxStaticBitmap(this, wxID_ANY, wxBitmap(wxImage(PIC_PATH + _T("Point.png"),wxBITMAP_TYPE_PNG)), wxPoint(-6, -6));
    title4 = new wxStaticText(this, CAPACITY_REMAINING, _("Device(s) disabled for power saving:"), wxPoint(41, 13), wxDefaultSize);

    vector<string> devicesVec;
    int schemeId = 0;
    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(schemeId);
    int ac_adapter = BatteryInfoMgmtProxy::PM_GetACAdapterStatus();

    int isAC = 0;

    if (ac_adapter == 1)
    {
        isAC = 1;
    }
    PowerSchemeMgmtProxy::GetInstance()->GetDisabledDevices(schemeId, isAC, devicesVec);

    map<string, string> deviceDescMap;
    PowerSchemeMgmtProxy::GetInstance()->GetDevicesDesc(deviceDescMap);

    wxString temp = wxEmptyString;
    int size = devicesVec.size();
    if (size != 0)
    {
        for (int i = 0; i < size; i++)
        {
            temp += PMUtility::StringToWxString(deviceDescMap[devicesVec[i]]);
            if (i != (size - 1))
            {
                temp += wxT("; ");
            }
        }

        temp += wxT(".");
    }

    title5 = new wxStaticText(this, CAPACITY_REMAINING, temp, wxPoint(41, 48), wxDefaultSize);
    title4->Wrap(180);
    title5->SetForegroundColour(wxColour(235, 90, 0));

    if (0 == alert)
    {
        title6 = new wxHyperlinkCtrl(this, LINK, _("Battery Status>>"), wxT(""), wxPoint(100, 65), wxDefaultSize);
        title6->Connect(LINK, wxEVT_LEFT_UP, (wxObjectEventFunction)&PMBalloonWnd::OnClickToInfo);
        title6->SetHoverColour(wxColour(wxT("blue")));
        title6->SetNormalColour(wxColour(19, 80, 192));
        title6->SetBackgroundColour(wxColour(226, 226, 223));
        MovePosition();
    }

}

void PMBalloonWnd::MouseOnAction(wxMouseEvent& event)
{
    wxWindow* wnd = static_cast<wxWindow*>(event.GetEventObject());
    wnd->SetForegroundColour(wxColour(wxT("orange")));
}

void PMBalloonWnd::MouseLeaveAction(wxMouseEvent& event)
{
    wxWindow* wnd = static_cast<wxWindow*>(event.GetEventObject());
    wnd->SetForegroundColour(wxColour(19, 80, 192));
}

void PMBalloonWnd::showBalloon()
{
    this->Show(false);
    this->Show(true);
}

void PMBalloonWnd::OnClickToList(wxMouseEvent&)
{
    DialogRegister* p = DialogRegister::GetInstance();
    PMTrayIcon* pTask = p->GetPtrTask();
    pTask->ChangeBalloonToList();
}

void PMBalloonWnd::OnClickToInfo(wxMouseEvent&)
{
    DialogRegister* p = DialogRegister::GetInstance();
    PMTrayIcon* pTask = p->GetPtrTask();
    pTask->ChangeBalloonToStatus();
}

void PMBalloonWnd::MovePosition()
{
    this->Center();
    wxPoint pos = wxGetMousePosition();
    wxPoint finalPos;
    int width = 0;
    int height = 0;
    const int miniLap = 15;

    ::wxDisplaySize(&width, &height);

    if (pos.x >= width / 2 && pos.y <= height / 2)
    {
        finalPos = wxPoint(pos.x - WIDTH - miniLap, pos.y + miniLap);
    }
    else if (pos.x > width / 2 && pos.y > height /2)
    {
        finalPos = wxPoint(pos.x - WIDTH - miniLap, pos.y - HEIGHT - miniLap);
    }
    else if (pos.x < width / 2 && pos.y > height /2)
    {
        finalPos = wxPoint(pos.x + miniLap, pos.y - HEIGHT - miniLap);
    }
    else
    {
        finalPos = wxPoint(pos.x + miniLap, pos.y + miniLap);
    }

    this->Move(finalPos);
}

void PMBalloonWnd::PopupNotification()
{
    //wxMessageBox(wxT("hello"));
    staticBitmap1 = new wxStaticBitmap(this, wxID_ANY, wxBitmap(wxImage(PIC_PATH + _T("PM-35.png"),wxBITMAP_TYPE_PNG)), wxPoint(10, 15));
    title1 = new wxStaticText(this, wxID_ANY, _("Power Manager is running. You can click Power Manager tray icon to use it!"), wxPoint(55, 10), wxDefaultSize);
    title1->SetForegroundColour(wxColour(20, 80, 190));
    title1->Wrap(this->GetSize().GetWidth() - 65);


    int width = 0;
    int height = 0;
    wxPoint finalPos;

    ::wxDisplaySize(&width, &height);
    finalPos = wxPoint(width - WIDTH, 5);

    this->Move(finalPos);
//    this->Show();
//    m_notificationtimer.Start(3000, wxTIMER_ONE_SHOT);
}

void PMBalloonWnd::CloseNotification(wxTimerEvent & event)
{
    this->Destroy();
}
