/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          BitmapDialog.h

Description:

    This file defines class BitmapDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef WXBITMAPDIALOG_H
#define WXBITMAPDIALOG_H

#include <wx/dialog.h>
#include <wx/bitmap.h>
#include <wx/frame.h>
#include <wx/dc.h>
#include <wx/dcclient.h>
//  ===========================================================================
//  class   wxBitmapDialog
//  desc    This class can be used to skin Dialogs
//          To use this class create Dialog and then make the dialog class
//          derive from wxBitmapDialog instead of wxDialog
//  ===========================================================================
class wxBitmapDialog : public wxDialog
{
    public:
        //  =======================================================================
        //  desc    constructor / desctructors
        //
        //  arg1    handle to the bitmap for the bitmap
        //  =======================================================================
        wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title);
        wxBitmapDialog(wxBitmap& bitmap, wxWindow* parent, const wxString& title);

        virtual ~wxBitmapDialog();

    private:
        void Init();

        wxBitmap m_bitmap;
        bool     m_hasShape;
        wxPoint  m_delta;

        void SetWindowShape();

        void OnLeftDown(wxMouseEvent& evt);
        void OnLeftUp(wxMouseEvent& evt);
        void OnMouseMove(wxMouseEvent& evt);

        void OnEraseBkgnd(wxEraseEvent& event);
        void OnSize(wxSizeEvent& event);
        void OnPaint(wxPaintEvent& event);
        void OnWindowCreate(wxWindowCreateEvent& evt);

        DECLARE_EVENT_TABLE()
};

#endif // WXBITMAPDIALOG_H
