/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          ConfigurationFileEditor.h

Description:

    This file defines class ConfigurationFileEditor.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef CONFIGURATIONFILEEDITOR_H_INCLUDED
#define CONFIGURATIONFILEEDITOR_H_INCLUDED

#include "../xmlparser/tinyxml.h"

#include <string>
#include <vector>
#include <map>
using namespace std;

typedef struct tagSchemeList_t
{
    string name;
    int id;
    int value;
}SchemeList_t, *PSchemeList_t;

const string OPTIONFILE("/.ipm/Options.xml");

const string ROOT("options");
const string SCHEME_SUB("scheme");
const string ITEM("item");
const string SCHEMEID("schemeid");
const string NAME("name");
const string VALUE("value");
const string WARNING_SUB("warning");
const string SWITCH("switch");
const string DEVICES_SUB("devices");
const string AUTO_START("autostart");

class ConfigurationFileEditor
{
public:
    ConfigurationFileEditor();
    ~ConfigurationFileEditor();

    int Add(PSchemeList_t scheme);
    int Edit(PSchemeList_t scheme);
    int Delete(int id);
    int Read(vector<PSchemeList_t> &schemeVec);
    int Save(int autoStart, int warning);
    int ReadSwitchWarning(int &value);
    int GetAutoStart(int &value);

    int RecordDevicesOldStatus(int schemeId, vector<string> &deviceVec);
    int ReadDevicesOldStatus(int schemeId, vector<string> &deviceVec);



private:
    int InitSchemeFilePath();
    string m_FilePath;
};

#endif // CONFIGURATIONFILEEDITOR_H_INCLUDED
