/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMBalloonWnd.h

Description:

    This file defines class PMBalloonWnd.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMBalloonWnd_H_INCLUDED
#define PMBalloonWnd_H_INCLUDED

#include <wx/event.h>
#include <wx/timer.h>
#include <wx/frame.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/dcprint.h>
#include <wx/dcclient.h>
#include <wx/image.h>
#include <wx/statbmp.h>
#include "BitmapDialog.h"
#include <wx/msgdlg.h>
#include <wx/hyperlink.h>
#include <vector>

#include "BatteryInfoMgmtProxy.h"
#include "PowerSchemeMgmtProxy.h"
#include "PMTrayIcon.h"

using namespace std;

enum BalloonCtrl
{
    CAPACITY_REMAINING = wxID_ANY,
    TIME_REMAININF = wxID_ANY,
    LINK = wxID_ANY
};

class PMBalloonWnd :  public wxBitmapDialog
{
    public:
        PMBalloonWnd(wxWindow *dlg, const wxString& title);
        virtual ~PMBalloonWnd();

        void OnClickToList(wxMouseEvent & event);
        void OnClickToInfo(wxMouseEvent & event);
        void showBalloon();
        void InitStatusBalloon();
        void InitDeviceListBalloon(int alert = 0);
        void MouseOnAction(wxMouseEvent& event);
        void MouseLeaveAction(wxMouseEvent& event);
        void MovePosition();
        void PopupNotification();
        void CloseNotification(wxTimerEvent & event);

    private:

        wxStaticText* title1;
        wxStaticText* title2;
        wxHyperlinkCtrl* title3;
        wxStaticText* title4;
        wxStaticText* title5;
        wxHyperlinkCtrl* title6;
        wxStaticBitmap *staticBitmap1;

        wxTimer m_notificationtimer;

        DECLARE_EVENT_TABLE();

};

#endif // PMBalloonWnd_H_INCLUDED
