/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMEditDialog.h

Description:

    This file defines class PMEditDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMEDITDIALOG_H
#define PMEDITDIALOG_H

//(*Headers(PMEditDialog)
#include <wx/notebook.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/gauge.h>
//*)

#include <wx/wx.h>
#include <wx/string.h>

#include "PMUtility.h"
#include "PowerSchemeMgmtProxy.h"
#include "ConfigurationFileEditor.h"



class PMEditDialog: public wxDialog
{
	public:

		PMEditDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~PMEditDialog();

        int Init(int schemeId, int isAC);

        int SetSchemeInfo(PScheme_Info pSchemeInfo);
        int SetSchemeDCInfo(PScheme_Settings dcSettingsInfo);
        int SetSchemeACInfo(PScheme_Settings acSettingsInfo);

        void UpdateDeviceStatus(int isAC, vector<string> &changedDeviceVector, int schemeId);

		//(*Declarations(PMEditDialog)
		wxStaticText*  StaticText_UI_AC_LCDBrightness;
		wxNotebook* Settings;
		wxComboBox* ComboBox_DC_LANSpeed;
		wxComboBox* ComboBox_DC_EnterSYSStandby;
		wxStaticText* StaticText_UI_DC_EnterSysStandby;
		wxComboBox* ComboBox_AC_LCDBrightness;
		wxGauge* Gauge_DC_LCDBrightness;
		wxGauge* Gauge_AC_LCDBrightness;
		wxStaticText* StaticText_UI_AC_PowerSettings;
		wxTextCtrl* TextCtrl_SchemeName;
		wxPanel* Panel_AC_Settings;
		wxButton* Button_Save;
		wxCheckBox* CheckBox_AC_DisableLAN;
		wxStaticText* StaticText_UI_DC_LCDBrightness;
		wxStaticText* StaticText_UI_AC_Performance;
		wxStaticText* StaticText_UI_DC_BatteryLife;
		wxStaticText* StaticText_UI_DC_PowerSettings;
		wxStaticText* StaticText_UI_DC_EffectiveOfSettings;
		wxStaticText* StaticText_UI_AC_EffectiveOfSettings;
		wxStaticText* StaticText_UI_AC_EnterSYSStandby;
		wxCheckBox* CheckBox_AC_DisableWireless;
		wxStaticText* StaticText_UI_AC_BatteryLife;
		wxGauge* Gauge_DC_BatteryLife;
		wxButton* Button_Reset;
		wxStaticText* StaticText_AC_BatteryLife;
		wxStaticText* StaticText_UI_DC_LANSpeed;
		wxStaticLine* StaticLine2;
		wxStaticText* StaticText_UI_AC_TurnOffDisplay;
		wxStaticText* StaticText_UI_DC_Performance;
		wxStaticText* StaticText_UI_DC_LCDBrightness2;
		wxGauge* Gauge_DC_Performance;
		wxButton* Button_Cancel;
		wxStaticText* StaticText_UI_AC_LANSpeed;
		wxComboBox* ComboBox_DC_LCDBrightness;
		wxStaticLine* StaticLine1;
		wxCheckBox* CheckBox_DC_DisableWireless;
		wxComboBox* ComboBox_AC_EnterSYSStandby;
		wxStaticText* StaticText_UI_DC_TurnOffDisplay;
		wxComboBox* ComboBox_AC_LANSpeed;
		wxStaticText* StaticText_UI_E_SchemeName;
		wxCheckBox* CheckBox_DC_DisableLAN;
		wxComboBox* ComboBox_AC_TurnOffDisplay;
		wxPanel* Panel_DC_Settings;
		wxGauge* Gauge_AC_Performance;
		wxComboBox* ComboBox_DC_TurnOffDisplay;
		wxStaticText*  StaticText_UI_AC_LCDBrightness2;
		//*)

	protected:

		//(*Identifiers(PMEditDialog)
		static const long ID_STATICTEXT_UI_E_SCHEMENAME;
		static const long ID_TEXTCTRL_SCHEMENAME;
		static const long ID_STATICTEXT_UI_DC_POWERSETTINGS;
		static const long ID_STATICTEXT_UI_DC_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_DC_LANSPEED;
		static const long ID_STATICTEXT_UI_DC_TURNOFFDISPLAY;
		static const long ID_STATICTEXT_UI_DC_ENTERSYSSTANDBY;
		static const long ID_CHECKBOX_DC_DISABLEWIRELESS;
		static const long ID_CHECKBOX_DC_DISABLELAN;
		static const long ID_COMBOBOX_DC_LCDBRIGHTNESS;
		static const long ID_COMBOBOX_DC_LANSPEED;
		static const long ID_COMBOBOX_DC_TURNOFFDISPLAY;
		static const long ID_COMBOBOX_DC_ENTERSYSSTANDBY;
		static const long ID_STATICTEXT_UI_DC_EFFECTIVEOFSETTINGS;
		static const long ID_STATICTEXT_UI_DC_PERFORMANCE;
		static const long ID_STATICTEXT_UI_Dc_LCDBRIGHTNESS2;
		static const long ID_STATICTEXT_UI_DC_BATTERYLIFE;
		static const long ID_GAUGE_DC_PERFORMANCE;
		static const long ID_GAUGE_DC_LCDBRIGHTNESS;
		static const long ID_GAUGE_DC_BATTERYLIFE;
		static const long ID_STATICLINE1;
		static const long ID_PANEL_DC_SETTINGS;
		static const long ID_STATICTEXT_UI_AC_POWERSETTINGS;
		static const long ID_STATICTEXT_UI_AC_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_AC_LANSPEED;
		static const long ID_STATICTEXT_UI_AC_TURNOFFDISPLAY;
		static const long ID_STATICTEXT_UI_AC_ENTERSYSSTANDBY;
		static const long ID_CHECKBOX_AC_DISABLEWIRELESS;
		static const long ID_CHECKBOX_AC_DISABLELAN;
		static const long ID_COMBOBOX_AC_LANSPEED;
		static const long ID_COMBOBOX7;
		static const long ID_COMBOBOX_AC_LCDBRIGHTNESS;
		static const long ID_COMBOBOX_AC_ENTERSYSSTANDBY;
		static const long ID_STATICTEXT_UI_AC_PERFORMANCE;
		static const long ID_STATICTEXT_UI_AC_LCDBRIGHTNESS2;
		static const long ID_STATICTEXT_UI_AC_EFFECTIVEOFSETTINGS;
		static const long ID_STATICTEXT_UI_AC_BATTERYLIFE;
		static const long ID_GAUGE_AC_LCDBRIGHTNESS;
		static const long ID_GAUGE_AC_PERFORMANCE;
		static const long ID_STATICTEXT_AC_BATTERYLIFE;
		static const long ID_STATICLINE2;
		static const long ID_PANEL_AC_SETTINGS;
		static const long ID_NOTEBOOK_Settings;
		static const long ID_BUTTON_RESET;
		static const long ID_BUTTON_SAVE;
		static const long ID_BUTTON_CANCEL;
		//*)

	private:

		//(*Handlers(PMEditDialog)
		void OnButton_ResetClick(wxCommandEvent& event);
		void OnButton_SaveClick(wxCommandEvent& event);
		void OnButton_CancelClick(wxCommandEvent& event);
		void OnClose(wxCloseEvent& event);
		//*)

		DECLARE_EVENT_TABLE()

	private:

        void SetComboboxValue(void);
        int SaveSchemeInfo(void);
        int UpdateDCEffectiveness(map<string, int> valueMap);
        int UpdateACEffectiveness(map<string, int> valueMap);

        // Combobox event
        void OnComboBox_DCSelect(wxCommandEvent& event);
        void OnComboBox_ACSelect(wxCommandEvent& event);

    private:

        int m_iSchemeId;
        int m_iDefaultSchemeFlag; //Save button clicking flag

        PScheme_Info m_ptagSchemeInfo_t;//SaveSchemeInfo

        SETTING_ITEM_VECTOR vLCDBrightnessItems;
        SETTING_ITEM_VECTOR vLANSpeedItems;
        SETTING_ITEM_VECTOR vCloseLCDItems;
        SETTING_ITEM_VECTOR vStandbyItems;
};
#endif
