/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMTrayIcon.h

Description:

    This file defines class PMTrayIcon.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMTRAYICON_H_INCLUDED
#define PMTRAYICON_H_INCLUDED

#include "wx/taskbar.h"
#include <wx/bitmap.h>

#include "PMMenu.h"
#include "PMBalloonWnd.h"
#include <wx/event.h>
#include <wx/utils.h>
#include <vector>
#include "PMApp.h"
#include "DialogRegister.h"
#include "PMDialog.h"
#include "BatteryInfoMgmtProxy.h"
#include "PMGlobalConstant.h"
using namespace std;

class PMMenu;
class PMBalloonWnd;
class PMDialog;
class BatteryInfoDialog;

void CALLBACK ENM_shutdown_lan_interface(int *result);
void CALLBACK ENM_shutdown_wlan_interface(int *result);

class PMTrayIcon: public wxTaskBarIcon
{
public:
    PMTrayIcon(bool bAutoStart);
    ~PMTrayIcon();

    //void OnLeftButtonDClick(wxTaskBarIconEvent&);
    void OnMouseOver(wxTaskBarIconEvent&);
    void OnLeftButtonUp(wxTaskBarIconEvent&);
    void OnRightButtonUp(wxTaskBarIconEvent&);
    wxMenu *CreatePopupMenu();
    void OnTimerTick(wxTimerEvent & event);
    void GetBatteryInfo(wxTimerEvent & event);
    void ChangeBalloonToList();
    void ChangeBalloonToStatus();

    void ShowPMDlg();
    void ShowBatteryDlg();
    void ShowMenu();
    bool UpdateIcon(PDCS_Battery_Info batteryInfo);
    void SwitchPower();
    void PowerChangeEvent(wxTimerEvent & event);
    void IdleTimeEvent(wxTimerEvent & event);
    void SuspendEvent(wxTimerEvent & event);
    void Init();
    static bool IsProtocolSupported();
    static void ShowMessageDialog(wxString message);
    void StartIdleTimer();
    void StartLANTimer();
    void LANOverTimeHandler(wxTimerEvent & event);
   // void ClickTimeEvent(wxTimerEvent & event);

    static bool m_initState;
    friend void CALLBACK ENM_shutdown_lan_interface(int *result);
    friend void CALLBACK ENM_shutdown_wlan_interface(int *result);

private:
    int m_isAC;
    bool m_bAutoStart; // indicate whether the application starts with system
    bool m_firstnotray;
    bool m_bDoubleClick;
    PMMenu* m_ptrMenu;
    PMBalloonWnd* m_ptrBalloonInfo;
    PMBalloonWnd* m_ptrDeviceListBall;
    wxTimer * m_Timer;
    wxTimer * m_batteryInfoTimer;
    wxTimer * m_idleTimer_closelcd;
    wxTimer * m_idleTimer_suspend;
    PMDialog* m_ptrPMDialog;
    BatteryInfoDialog* m_ptrBatteryDialog;

    PMBalloonWnd* m_switchPower;
    wxTimer* m_switchTimer;
    wxTimer* m_clickTimer;
    wxTimer m_lan_timer;
    wxTimer m_wlan_timer;

    void CloseBalloonStatus();
    void CloseBalloonList();
    void ClosePowerSwitchBalloon();

    DECLARE_EVENT_TABLE()
};

#endif // PMTRAYICON_H_INCLUDED
