/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PowerSchemeMgmtProxy.h

Description:

    This file defines class PowerSchemeMgmtProxy.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef POWERSCHEMEMGMTPROXY_H_INCLUDED
#define POWERSCHEMEMGMTPROXY_H_INCLUDED

#include <cstdlib>
#include <string>
#include <iostream>
#include <map>
#include <vector>
using namespace std;

#include "../xmlparser/tinyxml.h"
//#include "DCSApi.h"
#include "PMApi.h"

const int APPLY_FAILED = -1;
const int SUCCESS = 0;
const int OPERATON_DENIED = 2;
const int FAILED = 6;
const int STRING_MAX_LEN = 256;
const int EFFECTIVE_ITEMS_COUNT = 2;

const string PRIVATE_SCHEME_FILEPATH("/.ipm/PowerScheme_pmsch.xml");
const string GLOBAL_PATH("/etc/ipower-management/config-file-bak/");
const string COMMON_FILEPATH("CommonSettings.xml");
const string DEFAULT_SCHEME_FILEPATH("PowerScheme_pmsch.xml");

/* Name of scheme settings variable. */
const char LCD_BRIGHTNESS[] = "LCDBrightness";
const char LAN_SPEED[] = "LANSpeed";
const char CLOSE_LCD[] = "CloseLCD";
const char STANDBY[] = "Standby";
const char LAN_STATUS[] = "LAN";
const char WLAN_STATUS[] = "Wireless";

/* Node name in CommonSettings.xml. */
const string COMMON_SETTINGS("globalsettings");
const string COMMON_PERSONAL("personalscheme");
const string COMMON_ITEMS("items");
const string COMMON_DEVICES("devices");
const string COMMON_EFFECTIVE("effectiveness");

/* Name of effectiveness variable. */
const string PERFORMANCE("Performance");
const string DISPLAY("DisplayBrightness");
const string BATTERYLIFE("BatteryLife");

const string SETTINGS("settings");
const string NAME_ATTRIBUTE("name");
const string DESC_ATTRIBUTE("description");
const string VALUE_ATTRIBUTE("value");
const string SCHEME_ITEM("item");
const string SCHEMES("schemes");
const string SCHEME("scheme");
const string ACVALUE("acvalue");
const string DCVALUE("dcvalue");
const string SCHEME_ID("schemeid");
const string DEFAULT_ATTRIBUTE("isdefault");
const string MAX_ATTRIBUTE("max");

const int TIMELIST_SECOND[] = {60, 120, 180, 300, 600, 900, 1200, 1500, 1800, 2700, 3600, 7200, 108000, 144000, 180000, 0};

typedef struct tagSchemeSettings
{
    int LCDBrightness;
    int LANSpeed;
    int CloseLCD;
    int Standby;
    int LANStatus;
    int WLANStatus;
}Scheme_Settings, *PScheme_Settings;

typedef struct tagSchemeInfo
{
    int SchemeId;
    int IsDefault;
    string SchemeName;
    PScheme_Settings ACSettings;
    PScheme_Settings DCSettings;
}Scheme_Info, *PScheme_Info;

typedef struct tagSettingItemInfo
{
    int Value;
    string Name;
    string Description;
}Setting_Item_Info, *PSetting_Item_Info;

typedef vector<Setting_Item_Info> SETTING_ITEM_VECTOR;
typedef map<string, SETTING_ITEM_VECTOR> SETTING_ITEM_MAPPING;
typedef map<string, int> STRING_MAP;


class PowerSchemeMgmtProxy
{
public:
    ~PowerSchemeMgmtProxy();
    static PowerSchemeMgmtProxy* GetInstance();

    int GetActivePwrScheme(int &schemeId);
    int AddPwrScheme(int &schemeId, PScheme_Info scheme);
    int ApplyPwrScheme(int schemeId);
    int DeletePwrScheme(int schemeId);
    int EditPwrScheme(PScheme_Info scheme);
    int EditPwrSchemeSettings(int schemeId, int isAC, PScheme_Settings schemeSettings);
    int QueryPwrScheme(PScheme_Info scheme);
    int QueryPwrSchemeSettings(int schemeId, int isAC, PScheme_Settings schemeSettings);
    int GetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int &value);
    int SetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int value);
    int EditPowerSchemeName(string schemeName, int schemeId);
    int GetPowerDefaultAttribute(int schemeId, int &isDefault);

    int GetDisabledDevices(int schemeId, int isAC, vector<string> &devicesVec);
    int SetDisabledDevices(int schemeId, int isAC, vector<string> &devicesVec, int value);

    int ResetDefaultScheme(int schemeId, int isAC, PScheme_Settings schemeSettings);
    int GetSettingItems(SETTING_ITEM_MAPPING &settingItemsMapping);

    int GetPersonalSchemeDefaultName(vector<string> &nameVec);
    int GetMaxNumberOfSchemes(int &maxNum);
    int GetDevicesDesc(map<string, string> &deviceDescMap);

    int CalculateEffectiveness(map<string, int>& valueMap, string varName);
    int CalculatePerformance(map<string, int>& valueMap, int &persent);
    int CalculateDisplayBrightness(map<string, int>& valueMap, int &persent);
    int CalculateBatteryLife(map<string, int>& valueMap, int &persent);
    int GetPwrVariableMaxCount(const char *itemName, int &count);
    int CalculateEffectiveRange(string effectiveName, int &maxRange, int &minRange);

    int InitScheme();
    static unsigned long g_CloseLCDTime;
    unsigned long GetIdleTime();

    static unsigned long g_SuspendTime;
    static bool EnterSuspend();

    static int g_LanOvertime;

private:
    PowerSchemeMgmtProxy();
    int GetDefaultSchemeInfo(int schemeId, int isAC, map<string, int> &settingMapping);
    int ReadWeight();
    int ApplySchemeSettings(int schemeId);

    int m_hasXSCExtension;
    unsigned long m_idleTime;

private:
    static PowerSchemeMgmtProxy* m_pPowerSchemeMgmtProxy;

    map<string, STRING_MAP> m_EffectivenessMap;
    map<string, int> m_EffectMaxValueMap;
};
#endif // POWERSCHEMEMGMTPROXY_H_INCLUDED
