/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          BitmapDialog.cpp

Description:

    This file implements class BitmapDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/BitmapDialog.h"

/**constructor*/
wxBitmapDialog::wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title)
: wxDialog(parent, id, title, wxDefaultPosition, wxDefaultSize, 0
                  | wxFRAME_SHAPED
                  | wxSIMPLE_BORDER
                  | wxFRAME_NO_TASKBAR
                  | wxSTAY_ON_TOP),
  m_bitmap(bitmap)
{
    Init();
}

/**constructor*/
wxBitmapDialog::wxBitmapDialog(wxBitmap& bitmap, wxWindow* parent, const wxString& title)
: wxDialog(parent, -1, title, wxDefaultPosition, wxDefaultSize, wxNO_BORDER),
  m_bitmap(bitmap)
{
    Init();
}

/**destructor*/
wxBitmapDialog::~wxBitmapDialog()
{
    //dtor
}

BEGIN_EVENT_TABLE(wxBitmapDialog, wxDialog)
 //   EVT_ERASE_BACKGROUND(wxBitmapDialog::OnEraseBkgnd)
    EVT_LEFT_DOWN(wxBitmapDialog::OnLeftDown)
    EVT_LEFT_UP(wxBitmapDialog::OnLeftUp)
    EVT_MOTION(wxBitmapDialog::OnMouseMove)
    EVT_PAINT(wxBitmapDialog::OnPaint)
#ifdef __WXGTK__
    EVT_WINDOW_CREATE(wxBitmapDialog::OnWindowCreate)
#endif
END_EVENT_TABLE()

/**************************************************************************************************
* Function Name : Init                                                                            *
* Description  : initial the dialog                                                               *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void wxBitmapDialog::Init()
{
    m_hasShape = FALSE;

    SetSize(wxSize(m_bitmap.GetWidth(), m_bitmap.GetHeight()));

#ifndef __WXGTK__
    // On wxGTK we can't do this yet because the window hasn't been created
    // yet so we wait until the EVT_WINDOW_CREATE event happens.  On wxMSW and
    // wxMac the window has been created at this point so we go ahead and set
    // the shape now.
    SetWindowShape();
#endif

    //SetBackgroundStyle(wxBG_STYLE_COLOUR);
}

/**window erase background event handler*/
void wxBitmapDialog::OnEraseBkgnd(wxEraseEvent&  event)
{
    wxDC* pDC = event.GetDC();
    if (pDC)
    {
        if (m_bitmap.Ok())
        {
            pDC->DrawBitmap(m_bitmap,0,0,true);
        }
    }
    else
    {
        wxClientDC dc(this);
        if (m_bitmap.Ok())
        {
            dc.DrawBitmap(m_bitmap,0,0,true);
        }
    }
}

/**window paint event handler*/
void wxBitmapDialog::OnPaint(wxPaintEvent& WXUNUSED(event))
 {
    wxPaintDC dc(this);
    dc.DrawBitmap(m_bitmap, 0, 0, TRUE);

}

/**mouse left down event handler*/
void wxBitmapDialog::OnLeftDown(wxMouseEvent& evt)
{
    CaptureMouse();
    wxPoint pos = ClientToScreen(evt.GetPosition());
    wxPoint origin = GetPosition();
    int dx =  pos.x - origin.x;
    int dy = pos.y - origin.y;
    m_delta = wxPoint(dx, dy);
}

/**mouse left up event handler*/
void wxBitmapDialog::OnLeftUp(wxMouseEvent& evt)
{
    if (HasCapture())
    {
        ReleaseMouse();
    }
}

/**mouse over event handler*/
void wxBitmapDialog::OnMouseMove(wxMouseEvent& evt)
{
    wxPoint pt = evt.GetPosition();
    if (evt.Dragging() && evt.LeftIsDown())
    {
        wxPoint pos = ClientToScreen(pt);
        Move(wxPoint(pos.x - m_delta.x, pos.y - m_delta.y));
    }
}

/**************************************************************************************************
* Function Name : SetWindowShape                                                                  *
* Description  : set the window shape                                                             *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void wxBitmapDialog::SetWindowShape()
{
    wxRegion region(m_bitmap, *wxBLACK);
    m_hasShape = SetShape(region);
}

/**window create event handler*/
void wxBitmapDialog::OnWindowCreate(wxWindowCreateEvent& evt)
{
    SetWindowShape();
}
